@echo OFF
rem  * *******************************************************************
rem  *               ENV1BASE.cmd - a Windows Command File               *
rem  *        This program is provided by SimoTime Technologies          *
rem  *           (C) Copyright 1987-2021 All Rights Reserved             *
rem  *             Web Site URL:   http://www.simotime.com               *
rem  *                   e-mail:   helpdesk@simotime.com                 *
rem  * *******************************************************************
rem  *
rem  * Text   - Provide a single point to set common environment variables.
rem  * Author - SimoTime Technologies
rem  * Date   - January 24, 1996
rem  *
rem  * Set the commonly used environment variables. This is used to provide
rem  * a single point for managing the commonly used environment variables.
rem  *
     set SimoLIBR=c:\SimoLIBR
     set BASELIB1=c:\SIMOSAM1\DEVL
     set BASELIB8=c:\SimoSAM8
     set BaseWIP1=c:\SimoSAM1\WIP1
     set DATAZERO=c:\SIMODATA\DEVL\DATA\ZERO
     set BASEAPP=%BaseLib1%
     set BASESYS=%BaseLib1%\SYS1
     set BASECAT=%BaseLib1%\DATA
     set UMAPALIB=%BASECAT%\ASC1
     set UMAPELIB=%BASECAT%\EBC1
     set SYSLOG=%BASESYS%\LOGS\SYSLOG_USER.DAT
     set SYSOUT=%BASEAPP%\LOGS\SYSOUT_SIMSAM01.txt
     set SLZMSG=%BASEAPP%\LOGS\SLZMSG_USER.TXT
     set PostNOTE=%BASEAPP%\LOGS\JOBLOG_SIMONOTE.TXT
     set SIMONOTE=%BASEAPP%\LOGS\JOBLOG_SIMONOTE.txt
     set USERPOST=%BASEAPP%\LOGS\ASSIGNED_USER_POST_FILE.txt
     call SIMONOTE "* SIMONOTE Job Log File is %SIMONOTE% "
     if [%1]==[] goto NO_POST
     set SYSOUT=%BaseLib1%\LOGS\SYSOUT_%1.txt
     call SIMONOTE "*******************************************************************************%1"
     call SIMONOTE "* ENV1BASE is preparing the System Environment..."
     call SIMONOTE "* SIMOLIBR is %SIMOLIBR%"
     call SIMONOTE "* MIFOSYS1 is %MIFOSYS1%"
     call SIMONOTE "* BASELIB1 is %BASELIB1%"
:NO_POST
rem  *
     set MQBASE=C:\Program Files\IBM\WebSphere MQ
rem  *
rem  * Set the location for the Apache-Tomcat Server...
     set CATALINA_HOME=C:\APACHETC\apache-tomcat-7.0.52
rem     set CATALINA_HOME=C:\Program Files (x86)\Java\jdk1.8.0_112
rem  *
rem  * Set the Environment for the Java Environment...
rem     set JAVABASE=C:\APACHETC\apache-tomcat-7.0.52
     set JAVABASE=C:\Program Files (x86)\Java\jdk1.8.0_112
     set JAVASDK="%JAVABASE%\bin"
     set JAVA_HOME=%JAVABASE%
     set JRE_HOME=%JAVABASE%
     set SIMOTCAT=%CATALINA_HOME%\webapps\simotcat
     set SIMPACKS=%CATALINA_HOME%\webapps\simotcat\WEB-INF\classes\simpacks
rem  *
rem  * Set the environment for the Micro Focus technology...
     set MIFOEDEV=C:\Program Files (x86)\Micro Focus\Enterprise Developer
     set MIFOVCBL=C:\Program Files (x86)\Micro Focus\Visual COBOL Build Tools
     set MIFOESTU=C:\Program Files (x86)\Micro Focus\Studio Enterprise Edition 6.0
     set MIFOEMFE="C:\Program Files (x86)\Micro Focus\Mainframe Express"
rem  *
rem  * Large file support, performance tuning and record locking of the File Handler
     set EXTFH=%BASESYS%\CONFIG\EXTFHBIG.CFG
rem  *
rem  * For IMS Support
     set ES_IMSLIB=%BASEAPP%\IMSLIB
     set ES_ACBLIB=%BASEAPP%\IMSLIB
rem  *
rem  * EZASOKETS Check EZASOKETS Enabled box or set ES_EZASOKET_SUPPORT=YES 
     set EZACONFG=BASESYS1\CONFIG\EZACONFG.dat
rem  *
rem  * Resource Allocation and Performance for SORT and non-Relational Data
rem  set MFJSENGINE=SYNCSORT
     set SORTSCHEME=1
     set SORTSPACE=750000000
     set TMP=C:\SORTWORK
rem  *
     set ES_ALLOC_OVERRIDE=%BASESYS%\CONFIG\CATMAPA1.cfg
rem  * For CORE_ON_ERROR function, ABEND Dump
rem  *     set COBCONFIG_=%BASESYS%\CONFIG\diagnose.cfg
rem  *
rem  * Consolidated Trace Facility (CTF)
rem  *     set MFTRACE_CONFIG=%BASESYS%\CONFIG\ctf.cfg 
rem  *     set MFTRACE_LOGS=c:\ctflogs
rem  *
rem  * For Job Restart, ABEND Recovery
     set MF_UCC11=Y
     set ES_JES_RESTART=Y
rem  *
rem  * Set environment for MFBSI (Micro Focus Batch Scheduling Interface)
     set ES_EMP_EXIT_1=mfbsiemx
     set MFBSI_DIR=%BASESYS%\LOGS\%JESSERVERNAME%
     set MFBSIEOP_CMD=ENABLE
     set MFBSIEOP_CSV=ENABLE
     set MFBSIEOP_HTM=ENABLE
     set MFBSIEOP_XML=ENABLE
rem  *
rem  * Set Behavior and Trace Flags for GETJOBDD
rem  *   Position=12345678/12345678
     set JDDFLAGS=nnnWnnnn/YYnnnnnn
rem  *
rem  * If not already set then set the PATH for Micro Focus Directories
     if "%SIMOPATH%" == "Y" goto JUMPPATH
     if "%MIFOSYS1%" == "EDEV" goto JUMPEDEV
     if "%MIFOSYS1%" == "VCBL" goto JUMPVCBL
     if "%MIFOSYS1%" == "ESTU" goto JUMPESTU
     if "%MIFOSYS1%" == "EMFE" goto JUMPEMFE
:JUMPEDEV
     set path=%BASESYS%\LOADLIB;%MIFOEDEV%\bin;%JAVASDK%;%BASEAPP%\JAVA;%PATH%;
     set CobCpy=%BASEAPP%\CobCpy1;%BASEAPP%\CobCpy2;%BASEAPP%\CobCpy6;%SimoLIBR%;%MIFOEDEV%\CPYLIB
     set MIFOBASE=%MIFOEDEV%
     goto JUMPPATH
:JUMPVCBL
     set path=%MIFOVCBL%\bin;%MIFOVCBL%;%JAVASDK%;%BASEAPP%\JAVA;%PATH%;
     set MIFOBASE=%MIFOVCBL%
     goto JUMPPATH
:JUMPESTU
     set MIFOBASE=%MIFOESTU%\Base
     set MIFOBIN=%MIFOBASE%\bin
     set path=%BASESYS%\LOADLIB;%MIFOBASE%;%MIFOBIN%;%JAVASDK%;%BASEAPP%\JAVA;%PATH%;
     set CobCpy=%BASEAPP%\CobCpy1;%BASEAPP%\CobCpy2;%BASEAPP%\CobCpy6;%SimoLIBR%;%MIFOBASE%\SOURCE
     goto JUMPPATH
:JUMPEMFE
     set MIFOBASE=%MIFOEMFE%\Base
     set MIFOBIN=%MIFOBASE%\bin
     set path=%BASESYS%\LOADLIB;%MIFOBASE%;%MIFOBIN%;%JAVASDK%;%BASEAPP%\JAVA;%PATH%;
     set CobCpy=%BASEAPP%\CobCpy1;%BASEAPP%\CobCpy2;%BASEAPP%\CobCpy6;%SimoLIBR%;%MIFOBASE%\SOURCE
     goto JUMPPATH
rem  *
:JUMPPATH
     set SIMOPATH=Y
rem  *
     set MAINFRAME_FLOATING_POINT=true
     set COBIDY=%BASEAPP%\COBIDY
     set COBPATH=.;%BASEAPP%\LOADLIB;%BASEAPP%\LOADLIB\GNTS;%BASESYS%\LOADLIB;%SimoLIBR%
     set LIBPATH=.;%BASEAPP%\LOADLIB;%BASEAPP%\LOADLIB\GNTS;%BASESYS%\LOADLIB;%SimoLIBR%
     set TXDIR=%BASESYS%\LOADLIB;%MIFOBASE%
     set CobCpy=%BASEAPP%\CobCpy1;%BASEAPP%\CobCpy2;%BASEAPP%\CobCpy6;%SimoLIBR%
rem  *
     set USERCLASS=%BASELIB1%\LOADLIB
     set CLASSPATH=.
     set CLASSPATH=%CLASSPATH%;%JAVABASE%
     set CLASSPATH=%CLASSPATH%;%JAVABASE%\lib
     set CLASSPATH=%CLASSPATH%;\%USERCLASS%\simpacks
     set CLASSPATH=%CLASSPATH%;C:\APACHETC\apache-tomcat-7.0.52\webapps\simotcat\WEB-INF\classes
     set CLASSPATH=%CLASSPATH%;C:\APACHETC\apache-tomcat-7.0.52\webapps\simotcat\WEB-INF\classes\simpacks
rem  *
     if "%MIFOSYS1%" == "ESTU" set CLASSPATH=%CLASSPATH%;%MIFOBIN%
     if "%MIFOSYS1%" == "EDEV" set CLASSPATH=%CLASSPATH%;%MIFOEDEV%
     if "%MIFOSYS1%" == "VCBL" set CLASSPATH=%CLASSPATH%;%MIFOVCBL%
     if "%MIFOSYS1%" == "VCBL" set CLASSPATH=%CLASSPATH%;%MIFOVCBL%\bin\mfcobol.jar
rem  *
     set JobStatus=0000
     call SimoNOTE "* Settings CmdName ENV1BASE.cmd, Version 20.05.22, %MIFOSYS1% "
     call SimoNOTE "* BaseAPP ..... %BASEAPP% "
rem *      call SimoNOTE "* MFBSIDIR .... %MFBSI_DIR% "
     call SimoNOTE "* MIFOSYS1 is %MIFOSYS1% "
     call SimoNOTE "* MIFOBASE is %MIFOBASE% "
     call SimoNOTE "* SIMOLIBR is %SIMOLIBR% "
