       IDENTIFICATION DIVISION.
       PROGRAM-ID.    CBLSTRC1.
       AUTHOR.        SIMOTIME TECHNOLOGIES.
      *****************************************************************
      * Copyright (C) 1987-2019 SimoTime Technologies.                *
      *                                                               *
      * All rights reserved.  Unpublished, all rights reserved under  *
      * copyright law and international treaty.  Use of a copyright   *
      * notice is precautionary only and does not imply publication   *
      * or disclosure.                                                *
      *                                                               *
      * Permission to use, copy, modify and distribute this software  *
      * for any non-commercial purpose and without fee is hereby      *
      * granted, provided the SimoTime copyright notice appear on all *
      * copies of the software. The SimoTime name or Logo may not be  *
      * used in any advertising or publicity pertaining to the use    *
      * of the software without the written permission of SimoTime    *
      * Technologies.                                                 *
      *                                                               *
      * Permission to use, copy, modify and distribute this software  *
      * for any commercial purpose requires a fee to be paid to       *
      * SimoTime Technologies. Once the fee is received by SimoTime   *
      * the latest version of the software will be delivered and a    *
      * license will be granted for use within an enterprise,         *
      * provided the SimoTime copyright notice appear on all copies   *
      * of the software. The SimoTime name or Logo may not be used    *
      * in any advertising or publicity pertaining to the use of the  *
      * software without the written permission of SimoTime           *
      * Technologies.                                                 *
      *                                                               *
      * SimoTime Technologies makes no warranty or representations    *
      * about the suitability of the software for any purpose. It is  *
      * provided "AS IS" without any expressed or implied warranty,   *
      * including the implied warranties of merchantability, fitness  *
      * for a particular purpose and non-infringement. SimoTime       *
      * Technologies shall not be liable for any direct, indirect,    *
      * special or consequential damages resulting from the loss of   *
      * use, data or projects, whether in an action of contract or    *
      * tort, arising out of or in connection with the use or         *
      * performance of this software                                  *
      *                                                               *
      * SimoTime Technologies                                         *
      * 15 Carnoustie Drive                                           *
      * Novato, CA 94949-5849                                         *
      * 415.883.6565                                                  *
      *                                                               *
      * RESTRICTED RIGHTS LEGEND                                      *
      * Use, duplication, or disclosure by the Government is subject  *
      * to restrictions as set forth in subparagraph (c)(1)(ii) of    *
      * the Rights in Technical Data and Computer Software clause at  *
      * DFARS 52.227-7013 or subparagraphs (c)(1) and (2) of          *
      * Commercial  Computer Software - Restricted Rights  at 48      *
      * CFR 52.227-19, as applicable.  Contact SimoTime Technologies, *
      * 15 Carnoustie Drive, Novato, CA 94949-5849.                   *
      *                                                               *
      *****************************************************************
      *      This program is provided by SimoTime Technologies        *
      *        Our e-mail address is: helpdesk@simotime.com           *
      *     Also, visit our Web Site at http://www.simotime.com       *
      *                                                               *
      *****************************************************************
      *
      *****************************************************************
      * Source Member: CBLSTRC1.CBL
      * Copy Files:    PASSROAD.CPY
      * Calls to:      SIMOROAD
      *                Copy Files:    PASSPARS.CPY
      *                Calls to:      SIMOPARS
      *****************************************************************
      *
      *                     ************
      *                     * CBLSTRJ1 *
      *                     ********jcl*
      *                          *
      *                     ************
      *                     * IEFBR14  *
      *                     ********utl*
      *                          *
      *    ************     ************     ************
      *    * SIMOADR1 *-----* CBLSTRC1 *-----* SIMOADR2 *
      *    ********dat*     ********cbl*     ********dat*
      *                          *   *
      *                          *   *       ************
      *                          *   ***call** SIMOROAD *
      *                          *           ********cbl*
      *                          *                *
      *                          *                *       ************
      *                          *                ***call** SIMOPARS *
      *                          *                        ********cbl*
      *                     ************
      *                     *   EOJ    *
      *                     ************
      *
      *****************************************************************
      *
       ENVIRONMENT DIVISION.
       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
           SELECT SIMOADR1-FILE  ASSIGN to      SIMOADR1
                  ORGANIZATION is SEQUENTIAL
                  ACCESS MODE  is SEQUENTIAL
                  FILE STATUS  is SIMOADR1-STATUS.
           SELECT SIMOADR2-FILE  ASSIGN to      SIMOADR2
                  ORGANIZATION is SEQUENTIAL
                  ACCESS MODE  is SEQUENTIAL
                  FILE STATUS  is SIMOADR2-STATUS.

      *****************************************************************
       DATA DIVISION.
       FILE SECTION.
       FD  SIMOADR1-FILE
           DATA RECORD    is SIMOADR1-RECORD.
       01  SIMOADR1-RECORD.
           05  SIMOADR1-CNTL-01 pic X(4).
           05  SIMOADR1-DATA-01 pic X(76).

       FD  SIMOADR2-FILE
           DATA RECORD    is SIMOADR2-RECORD.
       01  SIMOADR2-RECORD.
           05  SIMOADR2-CNTL-01 pic X(4).
           05  SIMOADR2-SIZE-01 pic 9(5).
           05  SIMOADR2-BLANK   pic X.
           05  SIMOADR2-DATA-01 pic X(246).

       WORKING-STORAGE SECTION.
       01  SIM-TITLE.
           05  T1 pic X(11) value '* CBLSTRC1 '.
           05  T2 pic X(32) value 'Processing a Street Address     '.
           05  T3 pic X(10) value ' v08.01.04'.
           05  T4 pic X(24) value ' http://www.simotime.com'.
       01  SIM-COPYRIGHT.
           05  C1 pic X(11) value '* CBLSTRC1 '.
           05  C2 pic X(20) value 'Copyright 1987-2019 '.
           05  C3 pic X(28) value '   SimoTime Technologies    '.
           05  C4 pic X(20) value ' All Rights Reserved'.

       01  SIM-THANKS-01.
           05  C1 pic X(11) value '* CBLSTRC1 '.
           05  C2 pic X(32) value 'Thank you for using this program'.
           05  C3 pic X(32) value ' provided from SimoTime Technolo'.
           05  C4 pic X(04) value 'gies'.

       01  SIM-THANKS-02.
           05  C1 pic X(11) value '* CBLSTRC1 '.
           05  C2 pic X(32) value 'Please send all inquires or sugg'.
           05  C3 pic X(32) value 'estions to the helpdesk@simotime'.
           05  C4 pic X(04) value '.com'.

       01  MESSAGE-BUFFER.
           05  MESSAGE-HEADER      pic X(11)   value '* CBLSTRC1 '.
           05  MESSAGE-TEXT.
               10  MESSAGE-TEXT-1  pic X(68)   value SPACES.
               10  MESSAGE-TEXT-2  pic X(188)  value SPACES.

       01  SIMOADR1-STATUS.
           05  SIMOADR1-STATUS-L   pic X.
           05  SIMOADR1-STATUS-R   pic X.
       01  SIMOADR1-EOF            pic X       value 'N'.
       01  SIMOADR1-OPEN-FLAG      pic X       value 'C'.

       01  SIMOADR2-STATUS.
           05  SIMOADR2-STATUS-L   pic X.
           05  SIMOADR2-STATUS-R   pic X.
       01  SIMOADR2-EOF            pic X       value 'N'.
       01  SIMOADR2-OPEN-FLAG      pic X       value 'C'.

       01  IO-STATUS.
           05  IO-STAT1            pic X.
           05  IO-STAT2            pic X.

       01  TWO-BYTES.
           05  TWO-BYTES-LEFT      pic X.
           05  TWO-BYTES-RIGHT     pic X.
       01  TWO-BYTES-BINARY        redefines   TWO-BYTES pic 9(4) comp.

       01  APPL-RESULT             pic S9(9)   comp.
           88  APPL-AOK            value 0.
           88  APPL-EOF            value 16.

       01  SIMOADR1-TOTAL.
           05  filler       pic X(23)  value 'SIMOADR1 line count is '.
           05  SIMOADR1-LOC pic 9(7)    value 0.

       01  SUB-AOK         pic 9(7)    value 0.
       01  SUB-MOD         pic 9(7)    value 0.
       01  SUB-POB         pic 9(7)    value 0.
       01  SUB-POX         pic 9(7)    value 0.
       01  SUB-OTH         pic 9(7)    value 0.
       01  SUB-TOT         pic 9(7)    value 0.

      *****************************************************************
      * The following copy file of the pass area for calling SIMODATE,
      * the date editing routine.
      *****************************************************************
       COPY PASSROAD.

      *****************************************************************
       PROCEDURE DIVISION.
           perform Z-POST-COPYRIGHT
           perform SIMOADR1-OPEN
           perform SIMOADR2-OPEN
           initialize SIMOADR2-RECORD

           perform until SIMOADR1-STATUS not = '00'
               perform SIMOADR1-READ
               if  SIMOADR1-STATUS = '00'
                   add 1 to SIMOADR1-LOC
      *        *   Prepare linkage section and call SimoROAD...
                   move 'UNK '           to SIMOADR2-CNTL-01
                   move 'SIMOROAD'       to RDPA-REQUEST
                   move SIMOADR1-CNTL-01 to RDPA-ADR1-CNTL
                   move SIMOADR1-DATA-01 to RDPA-ADR1-DATA
                   add 76 to ZERO    giving RDPA-ADR1-SIZE
                   call 'SIMOROAD'   using ROAD-PASS-AREA

                   if  RDPA-RESULT = 0
      *            *   The following two statements are for
      *            *   demonstration purposes.
      *            *   Write Input record to output file.
                       initialize SIMOADR2-RECORD
                       move SIMOADR1-CNTL-01 to SIMOADR2-CNTL-01
                       add RDPA-ADR1-SIZE    to ZERO
                                         giving SIMOADR2-SIZE-01
                       move SIMOADR1-DATA-01 to SIMOADR2-DATA-01
                       perform SIMOADR2-WRITE
                       initialize SIMOADR2-RECORD
                       move RDPA-ADR2-CNTL to SIMOADR2-CNTL-01
                       add RDPA-ADR2-SIZE  to ZERO
                                       giving SIMOADR2-SIZE-01
                       move RDPA-ADR2-DATA to SIMOADR2-DATA-01
                       perform SIMOADR2-WRITE
                       perform CALCULATE-SUB-TOTALS
                   else
                       move RDPA-ADR2-CNTL to SIMOADR2-CNTL-01
                       move RDPA-ADR2-DATA to SIMOADR2-DATA-01
                       move SIMOADR2-RECORD to MESSAGE-TEXT
                       perform Z-DISPLAY-CONSOLE-MESSAGE
                       perform SIMOADR2-WRITE
                       move SIMOADR1-DATA-01 to SIMOADR2-DATA-01
                       perform SIMOADR2-WRITE
                   end-if
               end-if
           end-perform

           perform DISPLAY-SUB-TOTALS
           perform Z-THANK-YOU

           GOBACK.

      *****************************************************************
      * The following routines are in alphabetical sequence..         *
      *****************************************************************

      *****************************************************************
       CALCULATE-SUB-TOTALS.
           evaluate RDPA-ADR2-CNTL
               when 'AOK ' add 1 to SUB-AOK
               when 'MOD ' add 1 to SUB-MOD
               when 'POB ' add 1 to SUB-POB
               when 'PO? ' add 1 to SUB-POX
               when OTHER  add 1 to SUB-OTH
           end-evaluate
           exit.

      *****************************************************************
       DISPLAY-SUB-TOTALS.
           add SUB-AOK SUB-MOD SUB-POB SUB-POX SUB-OTH to SUB-TOT
           move 'AOK .... ' to MESSAGE-TEXT
           move SUB-AOK     to MESSAGE-TEXT(10:7)
           perform Z-DISPLAY-CONSOLE-MESSAGE
           move 'MOD .... ' to MESSAGE-TEXT
           move SUB-MOD     to MESSAGE-TEXT(10:7)
           perform Z-DISPLAY-CONSOLE-MESSAGE
           move 'POB .... ' to MESSAGE-TEXT
           move SUB-POB     to MESSAGE-TEXT(10:7)
           perform Z-DISPLAY-CONSOLE-MESSAGE
           move 'PO? .... ' to MESSAGE-TEXT
           move SUB-POX     to MESSAGE-TEXT(10:7)
           perform Z-DISPLAY-CONSOLE-MESSAGE
           move 'Other .. ' to MESSAGE-TEXT
           move SUB-OTH     to MESSAGE-TEXT(10:7)
           move 'TOTAL .. ' to MESSAGE-TEXT
           move SUB-TOT     to MESSAGE-TEXT(10:7)
           perform Z-DISPLAY-CONSOLE-MESSAGE
           exit.

      *****************************************************************
      * I/O ROUTINES FOR SIMOADR1...                                  *
      *****************************************************************
       SIMOADR1-CLOSE.
           add 8 to ZERO giving APPL-RESULT.
           close SIMOADR1-FILE
           if  SIMOADR1-STATUS = '00'
               subtract APPL-RESULT from APPL-RESULT
           else
               add 12 to ZERO giving APPL-RESULT
           end-if
           if  APPL-AOK
               CONTINUE
           else
               move 'SIMOADR1-Failure-CLOSE...' to MESSAGE-TEXT
               perform Z-DISPLAY-CONSOLE-MESSAGE
               move SIMOADR1-STATUS to IO-STATUS
               perform Z-DISPLAY-CONSOLE-MESSAGE
               perform Z-ABEND-PROGRAM
           end-if
           exit.
      *---------------------------------------------------------------*
       SIMOADR1-READ.
           read SIMOADR1-FILE
           if  SIMOADR1-STATUS = '00'
               subtract APPL-RESULT from APPL-RESULT
           else
               if  SIMOADR1-STATUS = '10'
                   add 16 to ZERO giving APPL-RESULT
               else
                   add 12 to ZERO giving APPL-RESULT
               end-if
           end-if
           if  APPL-AOK
               CONTINUE
           else
               if  APPL-EOF
                   move 'Y' to SIMOADR1-EOF
               else
                   move 'SIMOADR1-Failure-GET...' to MESSAGE-TEXT
                   perform Z-DISPLAY-CONSOLE-MESSAGE
                   move SIMOADR1-STATUS to IO-STATUS
                   perform Z-DISPLAY-CONSOLE-MESSAGE
                   perform Z-ABEND-PROGRAM
               end-if
           end-if
           exit.
      *---------------------------------------------------------------*
       SIMOADR1-OPEN.
           add 8 to ZERO giving APPL-RESULT.
           open input SIMOADR1-FILE
           if  SIMOADR1-STATUS = '00'
               subtract APPL-RESULT from APPL-RESULT
               move 'O' to SIMOADR1-OPEN-FLAG
           else
               add 12 to ZERO giving APPL-RESULT
           end-if
           if  APPL-AOK
               CONTINUE
           else
               move 'SIMOADR1-Failure-OPEN...' to MESSAGE-TEXT
               perform Z-DISPLAY-CONSOLE-MESSAGE
               move SIMOADR1-STATUS to IO-STATUS
               perform Z-DISPLAY-CONSOLE-MESSAGE
               perform Z-ABEND-PROGRAM
           end-if
           exit.

      *****************************************************************
      * I/O ROUTINES FOR SIMOADR2...                                  *
      *****************************************************************
       SIMOADR2-WRITE.
           if  SIMOADR2-OPEN-FLAG = 'C'
               perform SIMOADR2-OPEN
           end-if
           write SIMOADR2-RECORD
           if  SIMOADR2-STATUS = '00'
               subtract APPL-RESULT from APPL-RESULT
           else
               if  SIMOADR2-STATUS = '10'
                   add 16 to ZERO giving APPL-RESULT
               else
                   add 12 to ZERO giving APPL-RESULT
               end-if
           end-if.
           if  APPL-AOK
               CONTINUE
           else
               move 'SIMOADR2-Failure-WRITE...' to MESSAGE-TEXT
               perform Z-DISPLAY-CONSOLE-MESSAGE
               move SIMOADR2-STATUS to IO-STATUS
               perform Z-DISPLAY-CONSOLE-MESSAGE
               perform Z-ABEND-PROGRAM
           end-if
           exit.
      *---------------------------------------------------------------*
       SIMOADR2-OPEN.
           add 8 to ZERO giving APPL-RESULT.
           open output SIMOADR2-FILE
           if  SIMOADR2-STATUS = '00'
               subtract APPL-RESULT from APPL-RESULT
               move 'O' to SIMOADR2-OPEN-FLAG
           else
               add 12 to ZERO giving APPL-RESULT
           end-if
           if  APPL-AOK
               CONTINUE
           else
               move 'SIMOADR2-Failure-OPEN...' to MESSAGE-TEXT
               perform Z-DISPLAY-CONSOLE-MESSAGE
               move SIMOADR2-STATUS to IO-STATUS
               perform Z-DISPLAY-CONSOLE-MESSAGE
               perform Z-ABEND-PROGRAM
           end-if
           exit.
      *---------------------------------------------------------------*
       SIMOADR2-CLOSE.
           add 8 to ZERO giving APPL-RESULT.
           close SIMOADR2-FILE
           if  SIMOADR2-STATUS = '00'
               subtract APPL-RESULT from APPL-RESULT
               move 'C' to SIMOADR2-OPEN-FLAG
           else
               add 12 to ZERO giving APPL-RESULT
           end-if
           if  APPL-AOK
               CONTINUE
           else
               move 'SIMOADR2-Failure-CLOSE...' to MESSAGE-TEXT
               perform Z-DISPLAY-CONSOLE-MESSAGE
               move SIMOADR2-STATUS to IO-STATUS
               perform Z-DISPLAY-CONSOLE-MESSAGE
               perform Z-ABEND-PROGRAM
           end-if
           exit.

      *****************************************************************
      * The following Z-Routines perform administrative tasks         *
      * for this program.                                             *
      *****************************************************************
      *
      *****************************************************************
      * ABEND the program, post a message to the console and issue    *
      * a STOP RUN.                                                   *
      *****************************************************************
       Z-ABEND-PROGRAM.
           if  MESSAGE-TEXT not = SPACES
               perform Z-DISPLAY-CONSOLE-MESSAGE
           end-if
           move 'PROGRAM-IS-ABENDING...'  to MESSAGE-TEXT
           perform Z-DISPLAY-CONSOLE-MESSAGE
           add 12 to ZERO giving RETURN-CODE
           STOP RUN.
      *    exit.

      *****************************************************************
      * Display CONSOLE messages...                                   *
      *****************************************************************
       Z-DISPLAY-CONSOLE-MESSAGE.
           if MESSAGE-TEXT-2 = SPACES
               display MESSAGE-BUFFER(1:79) upon console
           else
               display MESSAGE-BUFFER upon console
           end-if
           move all SPACES to MESSAGE-TEXT
           exit.

      ****************************************************************
      * Display the file status bytes. This routine will display as   *
      * two digits if the full two byte file status is numeric. If    *
      * second byte is non-numeric then it will be treated as a       *
      * binary number.                                                *
      *****************************************************************
       Z-DISPLAY-IO-STATUS.
           if  IO-STATUS not NUMERIC
           or  IO-STAT1    = '9'
               subtract TWO-BYTES-BINARY from TWO-BYTES-BINARY
               move IO-STAT2 to TWO-BYTES-RIGHT
               display '* CBLSTRC1 File-Status-' IO-STAT1 '/'
                       TWO-BYTES-BINARY upon console
           else
               display '* CBLSTRC1 File-Status-' IO-STATUS upon console
           end-if
           exit.

      *****************************************************************
       Z-POST-COPYRIGHT.
           display SIM-TITLE     upon console
           display SIM-COPYRIGHT upon console
           exit.

      *****************************************************************
       Z-THANK-YOU.
           display SIM-THANKS-01 upon console
           display SIM-THANKS-02 upon console
           exit.
      *****************************************************************
      *      This example is provided by SimoTime Technologies        *
      *        Our e-mail address is: helpdesk@simotime.com           *
      *     Also, visit our Web Site at http://www.simotime.com       *
      *****************************************************************
