@echo OFF
rem  * *******************************************************************
rem  *               CBLSTRE1.cmd - a Windows Command File               *
rem  *         This program is provided by SimoTime Technologies         *
rem  *           (C) Copyright 1987-2019 All Rights Reserved             *
rem  *             Web Site URL:   http://www.simotime.com               *
rem  *                   e-mail:   helpdesk@simotime.com                 *
rem  * *******************************************************************
rem  *
rem  * Text   - Read a file of  Street Address, create edited file.
rem  * Author - SimoTime Technologies
rem  * Date   - January 24, 1996
rem  *
rem  * The job will read an 80-byte file that contains street address
rem  * record. The job will then edit the street address and identify
rem  * PO Boxes. A new file of edited street addresses will be created.
rem  *
rem  * This set of programs will run on a Windows Systems and
rem  * Micro Focus technology.
rem  *
rem  *    ************
rem  *    * CBLSTRE1 *
rem  *    ********cmd*
rem  *         *
rem  *    ************
rem  *    * If Exist *
rem  *    *******stmt*
rem  *         *
rem  *    ************     ************     ************
rem  *    *   run    ******* SIMOLOGS ******* CONSOLE  *
rem  *    ************  *  ********cbl*  *  ************
rem  *         *        *                *
rem  *         *        *                *  ************
rem  *         *        *                ****  SYSLOG  *
rem  *         *        *                   ********txt*
rem  *         *        *
rem  *         *        **************************
rem  *         *                                 *
rem  *         *           ************     ************     ************
rem  *         *           * SIMOADR1 ******* CBLSTRC1 ******* SIMOADR2 *
rem  *         *           ********txt*     ********cbl*     ********csv*
rem  *         *                                 *
rem  *         *                            ************
rem  *         *                            * SIMOROAD *
rem  *         *                            ********cbl*
rem  *         *                                 *
rem  *         *                            ************
rem  *         *                            * SIMOPARS *
rem  *         *                            ********cbl*
rem  *    ************
rem  *    *   EOJ    *
rem  *    ************
rem  *
rem  *
rem  * *******************************************************************
rem  * Step   1   Delete any previously created file...
rem  *
     set CmdName=CBLSTRE1
     call ..\Env1Base
rem  *
     call SimoNOTE "*******************************************************%CmdName%.cmd"
     call SimoNOTE "Starting JobName %CmdName%.cmd"
:DeleteQSAM
     call SimoNOTE "Identify JobStep DeleteQSAM"
     set SIMOADR1=%BaseLib1%\DATA\Asc1\SIMOADR1.DAT
     set SIMOADR2=%BaseLib1%\DATA\Wrk1\SIMOADR2.DAT
     if exist %SIMOADR2% del %SIMOADR2%
rem  *
rem  * *******************************************************************
rem  * Step   2   Edit input, create a new output file...
rem  *
:CBLSTRC1
     call SimoNOTE "Identify JobStep ExecuteStreetAddressEditRoutine"
     run CBLSTRC1
     if "%ERRORLEVEL%" == "1" set JobStatus=0001
     if not "%JobStatus%" == "0000" goto :EojNOK
     if exist %SIMOADR2% goto :EojAok
     set JobStatus=0002
     goto :EojNok
:EojAOK
     call SimoNOTE "Finished CmdName %CmdName%, Job Status is %JobStatus%"
     goto :End
:EojNOK
     call SimoNOTE "ABENDING CmdName %CmdName%, Job Status is %JobStatus%"
     echo %DATE% - %TIME% Starting User ABEND Processing...>>%SYSLOG%
     set >>%SYSLOG%
     echo %DATE% - %TIME% Complete User ABEND Processing...>>%SYSLOG%
     goto :End
:End
     call SimoNOTE "DATATAKE is %SIMOADR1%"
     call SimoNOTE "DATAMAKE is %SIMOADR2%"
     call SimoNOTE "SYSOUT.. is %SYSOUT%"
     if not "%1" == "nopause" pause
     exit /B %JobStatus%
