@echo OFF
rem  * *******************************************************************
rem  *               CBLSTRE2.CMD - a Windows Command File               *
rem  *         This program is provided by SimoTime Technologies         *
rem  *           (C) Copyright 1987-2019 All Rights Reserved             *
rem  *             Web Site URL:   http://www.simotime.com               *
rem  *                   e-mail:   helpdesk@simotime.com                 *
rem  * *******************************************************************
rem  *
rem  * Text   - Create a Sequential Data Set on disk using ECHO function.
rem  * Author - SimoTime Technologies
rem  * Date   = January 24, 1996
rem  *
rem  * The first job step (DeleteQSAM) will delete any previously created
rem  * file. The second job step (CreateQSAM) will create a new file.
rem  *
rem  * This set of programs will run on a Personal Computer with Windows
rem  * and Micro Focus Net Express.
rem  *
     set CmdName=CBLSTRE2
     call ..\Env1Base
rem  *
     call SimoNOTE "*******************************************************%CmdName%.CMD"
     call SimoNOTE "Starting JobName %CmdName%.CMD"
rem  *
rem  * *******************************************************************
rem  * Step   1 of 2  Delete previously created QSAM file...
rem  *
:DeleteQSAM
     call SimoNOTE "Identify JobStep DeleteQSAM"
     set SIMOADR0=%BaseLib1%\DATA\Txt1\LSEQADR1.TXT
     if exist %SIMOADR0% del %SIMOADR0%
rem  *
rem  * *******************************************************************
rem  * Step   2 of 2  Create and populate a new QSAM file...
rem  *
:CreateQSAM
     call SimoNOTE "Identify JobStep CreateQSAM"
rem  *....1....:....2....:....3....:....4....:....5....:....6....:....7....:....8
echo INP   15  CARNOUSTIE DRIVE >>%SIMOADR0%
echo INP POST OFFICE BOX 9144   >>%SIMOADR0%
echo INP 123 MAIN STREET        >>%SIMOADR0%
echo INP POB 27                 >>%SIMOADR0%
echo INP 1317 ST. CHARLES AVE.  >>%SIMOADR0%
echo INP 23 Post Street         >>%SIMOADR0%
echo INP PO BOX 21637           >>%SIMOADR0%
echo INP 710 HOLLYWOOD BL.      >>%SIMOADR0%
echo INP 1271 MACDOUGAL LANE    >>%SIMOADR0%
echo INP 14 VAN NESS AVENUE     >>%SIMOADR0%
echo INP 77 SUNSET BL           >>%SIMOADR0%
echo INP P.O. BOX 1665          >>%SIMOADR0%
echo INP PO 94949-5849          >>%SIMOADR0%
echo INP 777 Seventh Avenue     >>%SIMOADR0%
echo INP PO   BOX 12638         >>%SIMOADR0%
echo INP    P   O   box 32447   >>%SIMOADR0%
echo INP 1564 Alameda de la Loma                          >>%SIMOADR0%
echo INP THE CORNER OF HOLLYWOOD AND VINE                 >>%SIMOADR0%
echo INP 16 LARKSPUR LANDING CIRCLE, SUITE 116            >>%SIMOADR0%
echo INP pO 0123456789 CAN you FiX tHiS AnD THAT TEst bL. >>%SIMOADR0%
echo INP 17 LINCOLN WAY, APT 101D                         >>%SIMOADR0%
echo INP 1454 Po Way                                      >>%SIMOADR0%
echo INP 1656 SOUTH EVANS AVE                             >>%SIMOADR0%
     if exist %SIMOADR0% goto :Convert
     set JobStatus=0020
     goto :EojNok
rem  *
:Convert
     set GETLS080=%BaseLib1%\DATA\Txt1\LSEQADR1.TXT
     set PUTRS080=%BaseLib1%\DATA\Asc1\SIMOADR1.DAT
     if exist %PUTRS080% erase %PUTRS080%
     run CV80ALAR
     if not "%ERRORLEVEL%" == "0" set JobStatus=0030
     if not "%JobStatus%" == "0000" goto :EojNOK
     if not exist %PUTRS080% set JobStatus=0035
     if not "%JobStatus%" == "0000" goto :EojNOK
     goto EojAok
rem  *
:EojAOK
     call SimoNOTE "Finished CmdName %CmdName%, Job Status is %JobStatus%"
     goto :End
:EojNOK
     call SimoNOTE "ABENDING CmdName %CmdName%, Job Status is %JobStatus%"
     echo %DATE% - %TIME% Starting User ABEND Processing...>>%SYSLOG%
     set >>%SYSLOG%
     echo %DATE% - %TIME% Complete User ABEND Processing...>>%SYSLOG%
     goto :End
:End
     call SimoNOTE "Conclude SysOut is %SYSOUT%"
     if not "%1" == "nopause" pause
     exit /B %JobStatus%
