//CBLSTRJ1 JOB SIMOTIME,CLASS=1,MSGCLASS=0,NOTIFY=CSIP1
//* *******************************************************************
//*       CBLSTRJ1.JCL - a JCL Member for Batch Job Processing        *
//*       This JCL Member is provided by SimoTime Technologies        *
//*           (C) Copyright 1987-2019 All Rights Reserved             *
//*             Web Site URL:   http://www.simotime.com               *
//*                   e-mail:   helpdesk@simotime.com                 *
//* *******************************************************************
//*
//* Text   - Read a file containing street addresses, write output.
//* Author - SimoTime Technologies
//* Date   - January 24, 1996
//*
//* The job will read an 80-byte file that contains street address
//* information. The job will also write a file containing the results
//* of the street address parse and edit functions..
//*
//* This set of programs will run on a mainframe under MVS or on a
//* Personal Computer with Windows and Micro Focus Mainframe Express.
//*
//*                     ************
//*                     * CBLSTRJ1 *
//*                     ********jcl*
//*                          *
//*                     ************
//*                     * IEFBR14  *
//*                     ********utl*
//*                          *
//*    ************     ************     ************
//*    * SIMOADR1 *-----* CBLSTRC1 *-----* SIMOADR2 *
//*    ********dat*     ********cbl*     ********dat*
//*                          *   *
//*                          *   *       ************
//*                          *   ***CALL** SIMOROAD *
//*                          *           ********cbl*
//*                          *             *
//*                          *             *       ************
//*                          *             ***CALL** SIMOPARS *
//*                          *                     ********cbl*
//*                     ************
//*                     *   EOJ    *
//*                     ************
//*
//* *******************************************************************
//* Step 1 of 2, Delete any previously created file...
//*
//QSAMDELT EXEC PGM=IEFBR14
//SIMOADR2  DD  DSN=SIMOTIME.DATA.SIMOADR2,DISP=(MOD,DELETE,DELETE),
//             STORCLAS=MFI,
//             SPACE=(TRK,5),
//             DCB=(RECFM=FB,LRECL=256,BLKSIZE=2560,DSORG=PS)
//*
//* *******************************************************************
//* Step 2 of 2, Edit input, create a new output file...
//*
//EXECDAT1 EXEC PGM=CBLSTRC1
//STEPLIB  DD  DSN=SIMOTIME.DEMO.LOADLIB1,DISP=SHR
//SIMOADR1 DD  DSN=SIMOTIME.DATA.SIMOADR1,DISP=SHR
//SIMOADR2 DD  DSN=SIMOTIME.DATA.SIMOADR2,
//             DISP=(NEW,CATLG,DELETE),
//             STORCLAS=MFI,
//             SPACE=(TRK,5),
//             DCB=(RECFM=FB,LRECL=256,BLKSIZE=2560,DSORG=PS)
//SYSOUT   DD  SYSOUT=*
//
