      *****************************************************************
      *     Data Structure or Pass Area used for calling SIMOPARS.    *
      *****************************************************************
      *         Copyright (C) 1987-2019 SimoTime Technologies         *
      *                     All Rights Reserved                       *
      *****************************************************************
      *              Provided by SimoTime Technologies                *
      *        Our e-mail address is: helpdesk@simotime.com           *
      *     Also, visit our Web Site at http://www.simotime.com       *
      *****************************************************************
      *                                                               *
      * PRS-REQUEST          Type of request, must be zero (0) for    *
      *                      parsing. This item is  provided by the   *
      *                      calling program and is not modified      *
      *                      by the parsing routine.                  *
      * PRS-STATUS           This is an indicator as to the success   *
      *                      or failure of the request. A value of    *
      *                      zero (0000) indicates the routine was    *
      *                      successful. A non-zero value indicates   *
      *                      a failure.                               *
      *                                                               *
      * ------------------------------------------------------------- *
      * The following fields are provided by the calling routine.     *
      *                                                               *
      * PRS-DELIMITER        This is a one byte character that is     *
      *                      used as a delimiter. This item is        *
      *                      provided by the calling program and      *
      *                      is not modified by the parsing routine.  *
      *                                                               *
      * PRS-KEEP-NULL-FIELDS This must be a Yes (Y) or No (N) value   *
      *                      (Y) will indicate a Yes, keep null field *
      *                      (N) will indicate a No and null fields   *
      *                      will be dropped.                         *
      * PRS-TERMINATOR       This must be a Yes (Y) or No (N) value   *
      *                      to indicate a character that will be     *
      *                      used for termination of the parsing.     *
      *                      If (Y) then the next parameter is used   *
      *                      as a termination character. If (N) the   *
      *                      buffer will be parsed according to the   *
      *                      size  of the buffer or maximum number    *
      *                      of table entries. This item is provided  *
      *                      by the calling program and is not        *
      *                      modified by the parsing routine.         *
      * PRS-TERMINATOR-BYTE  If the previous parameter is (Y) this    *
      *                      byte will be used to terminate the       *
      *                      parsing when it is encountered in the    *
      *                      data string. This item is provided by    *
      *                      the calling program and is not modified  *
      *                      by the parsing routine.                  *
      *                                                               *
      * PRS-BUFFER-SIZE      The size of the data string to be        *
      *                      parsed and must be a value of 1-1024.    *
      *                      This item is provided by the calling     *
      *                      program and is not  modified by the      *
      *                      parsing routine.                         *
      * PRS-BUFFER           This is the data string or field that    *
      *                      will be parsed. This item is provided    *
      *                      by the calling program and is not        *
      *                      modified by the parsing routine.         *
      *                                                               *
      * PRS-TABLE-MAX        The maximum number of table entries      *
      *                      available for the POSITION/SIZE values   *
      *                      of the words in the input buffer.        *
      *                      This item is provided by the calling     *
      *                      program and is not modified by the       *
      *                      parsing routine.                         *
      *                                                               *
      * ------------------------------------------------------------- *
      * The following fields are updated by the parsing routine.      *
      *                                                               *
      * PRS-NUMBER-OF-ITEMS  This is the number of keywords found     *
      *                      in the input data string. This item is   *
      *                      provided by the parsing routine.         *
      *                                                               *
      * PRS-LAST-SIG-BYTE    This is the position of the last         *
      *                      significant, non-delimiter byte. If the  *
      *                      PRS-TERMINATOR is "Y" this will be the   *
      *                      last significant byte before the         *
      *                      terminator byte.                         *
      *                                                               *
      * PRS-POSITION         This is a table of 64 elements of        *
      *                      4-bytes. The value is either zero (0)    *
      *                      or the position of a keyword within the  *
      *                      input data string. The first position    *
      *                      within the buffer is one (1).            *
      *                      This item is provided by the parsing     *
      *                      routine.                                 *
      * PRS-SIZE             This is a table of 64 elements of        *
      *                      4-bytes. The value is either zero (0)    *
      *                      or the size of a keyword within the      *
      *                      input data string. This item is provided *
      *                      by the parsing routine.                  *
      *                                                               *
      * ------------------------------------------------------------- *
      * NOTE...              The table element number is the number   *
      *                      of the word within the data buffer.      *
      *                      The data buffer is PRS-BUFFER.           *
      *                      For example, PRS-POSITION(1) would point *
      *                      to the position of the first character   *
      *                      of the first word in the data buffer     *
      *                      PRS-SIZE(1) would specify the number of  *
      *                      characters in the first word.            *
      *                                                               *
      *****************************************************************
       01  PRS-PARAMETERS.
           05  PRS-REQUEST          PIC X.
           05  PRS-STATUS           PIC 9(4).
      ***  Provided by the calling program...
           05  PRS-DELIMITER        PIC X.
           05  PRS-KEEP-NULL-FIELDS PIC X.
           05  PRS-TERMINATOR       PIC X.
           05  PRS-TERMINATOR-BYTE  PIC X.
           05  PRS-SPACE-TRUNCATION PIC X.

           05  PRS-BUFFER-SIZE      PIC 9(4).
           05  PRS-BUFFER           PIC X(2048).

           05  PRS-TABLE-MAX        PIC 9(4).

      ***  Updated by the parsing routine...
           05  PRS-NUMBER-OF-ITEMS  PIC 9(4).
           05  PRS-LAST-SIG-BYTE    PIC 9(4).
           05  PRS-POSITION         OCCURS 128 TIMES
                                    PIC 9(4).
           05  PRS-SIZE             OCCURS 128 TIMES
                                    PIC 9(4).
      ***  PASSPARS - End-of-Copy File - - - - - - - - - - - PASSPARS *
      *****************************************************************
      *
