      *****************************************************************
      *     Data Structure or Pass Area used for calling SIMOROAD.    *
      *****************************************************************
      *         Copyright (C) 1987-2019 SimoTime Technologies         *
      *                     All Rights Reserved                       *
      *****************************************************************
      *              Provided by SimoTime Technologies                *
      *        Our e-mail address is: helpdesk@simotime.com           *
      *     Also, visit our Web Site at http://www.simotime.com       *
      *****************************************************************
      * RDPA-REQUEST,   Type of request, must be "SIMOROAD" for
      *                 parsing. This item is provided by the calling
      *                 program and is not modified by the parse and
      *                 edit routine.
      * RDPA-RESULT,    This is an indicator as to the success or
      *                 failure of the request. A value of zero (0000)
      *                 indicates the routine was successful.
      *                 A non-zero value indicates a failure.
      * RDPA-ADR1-CNTL, This is a four byte string that is used to
      *                 specify input data. This string should
      *                 contain "INP ". This item is provided by the
      *                 calling program and is not modified by the
      *                 parse and edit routine.
      * RDPA-ADR1-DATA, This string must contain the street address
      *                 to be parsed and edited. This string is not
      *                 modified by the parse and edit routine.
      * RDPA-ADR1-SIZE, This is the size of the actual text within
      *                 the RDPA-ADR1-DATA string. This item is
      *                 created by the parse and edit routine.
      * RDPA-ADR2-CNTL, This is a four byte string that is used to
      *                 specify the result of the parse and edit
      *                 routine for the input street address. This
      *                 item is created by the parse and edit routine.
      * RDPA-ADR2-DATA, This string will contain the street address
      *                 that is created by the parse and edit routine.
      * RDPA-ADR2-SIZE, This is the size of the actual text within
      *                 the RDPA-ADR2-DATA string. This item is
      *                 created by the parse and edit routine.
      *
       01  ROAD-PASS-AREA.
           05  RDPA-REQUEST    PIC X(8).
           05  RDPA-RESULT     PIC S9(9)   COMP.
           05  RDPA-ADR1-CNTL  PIC X(4).
           05  RDPA-ADR1-DATA  PIC X(128).
           05  RDPA-ADR1-SIZE  PIC 9(5).
           05  RDPA-ADR2-CNTL  PIC X(4).
           05  RDPA-ADR2-DATA  PIC X(256).
           05  RDPA-ADR2-SIZE  PIC 9(5).
      *
      ***  PASSROAD - End-of-Copy File - - - - - - - - - - - PASSROAD *
      *****************************************************************
      *
