       IDENTIFICATION DIVISION.
       PROGRAM-ID.    SIMOROAD.
       AUTHOR.        SIMOTIME TECHNOLOGIES.
      *****************************************************************
      * Copyright (C) 1987-2019 SimoTime Technologies.                *
      *                                                               *
      * All rights reserved.  Unpublished, all rights reserved under  *
      * copyright law and international treaty.  Use of a copyright   *
      * notice is precautionary only and does not imply publication   *
      * or disclosure.                                                *
      *                                                               *
      * Permission to use, copy, modify and distribute this software  *
      * for any non-commercial purpose and without fee is hereby      *
      * granted, provided the SimoTime copyright notice appear on all *
      * copies of the software. The SimoTime name or Logo may not be  *
      * used in any advertising or publicity pertaining to the use    *
      * of the software without the written permission of SimoTime    *
      * Technologies.                                                 *
      *                                                               *
      * Permission to use, copy, modify and distribute this software  *
      * for any commercial purpose requires a fee to be paid to       *
      * SimoTime Technologies. Once the fee is received by SimoTime   *
      * the latest version of the software will be delivered and a    *
      * license will be granted for use within an enterprise,         *
      * provided the SimoTime copyright notice appear on all copies   *
      * of the software. The SimoTime name or Logo may not be used    *
      * in any advertising or publicity pertaining to the use of the  *
      * software without the written permission of SimoTime           *
      * Technologies.                                                 *
      *                                                               *
      * SimoTime Technologies makes no warranty or representations    *
      * about the suitability of the software for any purpose. It is  *
      * provided "AS IS" without any expressed or implied warranty,   *
      * including the implied warranties of merchantability, fitness  *
      * for a particular purpose and non-infringement. SimoTime       *
      * Technologies shall not be liable for any direct, indirect,    *
      * special or consequential damages resulting from the loss of   *
      * use, data or projects, whether in an action of contract or    *
      * tort, arising out of or in connection with the use or         *
      * performance of this software                                  *
      *                                                               *
      * SimoTime Technologies                                         *
      * 15 Carnoustie Drive                                           *
      * Novato, CA 94949-5849                                         *
      * 415.883.6565                                                  *
      *                                                               *
      * RESTRICTED RIGHTS LEGEND                                      *
      * Use, duplication, or disclosure by the Government is subject  *
      * to restrictions as set forth in subparagraph (c)(1)(ii) of    *
      * the Rights in Technical Data and Computer Software clause at  *
      * DFARS 52.227-7013 or subparagraphs (c)(1) and (2) of          *
      * Commercial  Computer Software - Restricted Rights  at 48      *
      * CFR 52.227-19, as applicable.  Contact SimoTime Technologies, *
      * 15 Carnoustie Drive, Novato, CA 94949-5849.                   *
      *                                                               *
      *****************************************************************
      *      This program is provided by SimoTime Technologies        *
      *        Our e-mail address is: helpdesk@simotime.com           *
      *     Also, visit our Web Site at http://www.simotime.com       *
      *                                                               *
      *****************************************************************
      * Source Member: SIMOROAD.CBL
      * Copy Files:    PASSPARS.CPY
      * Calls to:      SIMOPARS
      *****************************************************************
      * MAINTENANCE
      * -----------
      * 1994/02/27 Simmons, Created program.
      * 1994/03/17 Simmons, Fixed bug to correct recalculation of the
      *            size of the edited street address.
      *
      *****************************************************************
       DATA DIVISION.
       WORKING-STORAGE SECTION.

       01  SIM-TITLE.
           05  T1 pic X(11) value '* SIMOROAD '.
           05  T2 pic X(32) value 'Processing a Street Address     '.
           05  T3 pic X(10) value ' v08.03.28'.
           05  T4 pic X(24) value ' http://www.simotime.com'.
       01  SIM-COPYRIGHT.
           05  C1 pic X(11) value '* SIMOROAD '.
           05  C2 pic X(20) value 'Copyright 1987-2019 '.
           05  C3 pic X(28) value '   SimoTime Technologies    '.
           05  C4 pic X(20) value ' All Rights Reserved'.

       01  MESSAGE-BUFFER.
           05  MESSAGE-HEADER      pic X(11)   value '* SIMOROAD '.
           05  MESSAGE-TEXT.
               10  MESSAGE-TEXT-1  pic X(68)   value SPACES.
               10  MESSAGE-TEXT-2  pic X(188)  value SPACES.

       01  WORD-14                 pic X(14)   value SPACES.
       01  WORD-12                 pic X(12)   value SPACES.
       01  WORD-SIZE               pic 9(5)    value 0.

       01  X1                      pic 9(5)    value 0.
       01  X2                      pic 9(5)    value 0.
       01  X3                      pic 9(5)    value 0.

       01  LOWER-CASE  pic X(26)   value 'abcdefghijklmnopqrstuvwxyz'.
       01  UPPER-CASE  pic X(26)   value 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'.

      *****************************************************************
      * The following copy file is the pass area for calling SIMOPARS,
      * the field parsing routine.
      *****************************************************************
       COPY PASSPARS.

      *****************************************************************
       LINKAGE SECTION.
       COPY PASSROAD.

      *****************************************************************
       PROCEDURE DIVISION using ROAD-PASS-AREA.
      *    perform Z-POST-COPYRIGHT
           move 'UNK ' to RDPA-ADR2-CNTL
           move SPACES to RDPA-ADR2-DATA
           add 16 to ZERO giving RDPA-RESULT

           evaluate RDPA-ADR1-CNTL
               when 'INP ' perform PROCESS-STREET-ADDRESS
               when OTHER  perform Z-ABEND-INVALID-REQUEST
           end-evaluate

           GOBACK.

      *****************************************************************
      * The following routines are in alphabetical sequence..         *
      *****************************************************************
      * This routine is used for debugging purposes,
      *****************************************************************
       ADDR-FUNCTION-DISPLAY-WORDS.
      *    Display the contents of the parsing tables.
           add 1 to ZERO giving X1
           perform until PRS-SIZE(X1) = 0
                      or PRS-POSITION(X1) = 0
                      or X1       > PRS-TABLE-MAX
                      or X1       > PRS-NUMBER-OF-ITEMS
               move X1 to MESSAGE-TEXT(6:5)
               move PRS-POSITION(X1) to MESSAGE-TEXT(19:4)
               move PRS-SIZE(X1) to MESSAGE-TEXT(32:4)
               if  PRS-SIZE(X1) < 20
                   move PRS-BUFFER(PRS-POSITION(X1):PRS-SIZE(X1))
                     to MESSAGE-TEXT(50:PRS-SIZE(X1))
               else
                   move PRS-BUFFER(PRS-POSITION(X1):19)
                     to MESSAGE-TEXT(50:19)
               end-if
               perform Z-DISPLAY-CONSOLE-MESSAGE
               add 1 to X1
           end-perform
           exit.

      *****************************************************************
      * Call the SIMOPARS routine to parse the Street Addres
      *****************************************************************
       ADDR-FUNCTION-PARSE.
      *>   Prepare control items for parsing.
           move '0' to PRS-REQUEST
           add 9 to ZERO giving PRS-STATUS
           move ' ' to PRS-DELIMITER
           move 'N' to PRS-TERMINATOR
           move ' ' to PRS-TERMINATOR-BYTE
           add 32 to ZERO giving PRS-TABLE-MAX
           if  RDPA-ADR1-SIZE > 0
               add RDPA-ADR1-SIZE to ZERO giving PRS-BUFFER-SIZE
           else
               add 48             to ZERO giving PRS-BUFFER-SIZE
           end-if
           move ZERO to PRS-NUMBER-OF-ITEMS
      *>   Move the data string to the parsing buffer and call
      *>   the parsing routine.
           move RDPA-ADR1-DATA to PRS-BUFFER
           call 'SIMOPARS'   using PRS-PARAMETERS
           if  PRS-STATUS not = 0
               move 'Parsing Failure of Address Field' to MESSAGE-TEXT
               perform Z-ABEND-PROGRAM
           end-if
           exit.

      *****************************************************************
       BUILD-NEW-STREET-ADDRESS.
           move SPACES to RDPA-ADR2-DATA
           inspect PRS-BUFFER(1:PRS-BUFFER-SIZE)
                   converting UPPER-CASE to LOWER-CASE
           add 1 to ZERO giving X1
           add 1 to ZERO giving X2
           perform until PRS-SIZE(X1) = 0
                      or PRS-POSITION(X1) = 0
                      or X1       > PRS-TABLE-MAX
                      or X1       > PRS-NUMBER-OF-ITEMS
               if  PRS-BUFFER(PRS-POSITION(X1):1) is NUMERIC
                   move PRS-BUFFER(PRS-POSITION(X1):PRS-SIZE(X1))
                     to RDPA-ADR2-DATA(X2:PRS-SIZE(X1))
                   inspect
                       RDPA-ADR2-DATA(X2:PRS-SIZE(X1))
                       converting LOWER-CASE to UPPER-CASE
                   add PRS-SIZE(X1) to X2
                   add 1            to X2
               else
                   perform BUILD-NEW-STREET-ADDRESS-100
               end-if
               add 1 to X1
           end-perform
           exit.

      *---------------------------------------------------------------*
       BUILD-NEW-STREET-ADDRESS-100.
           if  PRS-BUFFER(PRS-POSITION(X1):1) = 'p'
           and PRS-SIZE(X1)               < 5
               move SPACES to WORD-14
               move PRS-BUFFER(PRS-POSITION(X1):PRS-SIZE(X1))
                 to WORD-14
               perform BUILD-NEW-STREET-POSSIBLE-POB
           else
               perform BUILD-NEW-STREET-NORMAL-WORD
           end-if
           exit.

      *---------------------------------------------------------------*
       BUILD-NEW-STREET-POSSIBLE-POB.
           evaluate WORD-14
               when 'pob       ' perform BUILD-NEW-STREET-POSSIBLE-PO-1
               when 'pobox     ' perform BUILD-NEW-STREET-POSSIBLE-PO-1
               when 'p.o.box   ' perform BUILD-NEW-STREET-POSSIBLE-PO-1
               when 'pob.      ' perform BUILD-NEW-STREET-POSSIBLE-PO-1
               when 'po        ' perform BUILD-NEW-STREET-POSSIBLE-PO-2
               when 'p.o.      ' perform BUILD-NEW-STREET-POSSIBLE-PO-2
               when 'p.        ' perform BUILD-NEW-STREET-POSSIBLE-PO-3
               when 'p         ' perform BUILD-NEW-STREET-POSSIBLE-PO-3
               when 'post      ' perform BUILD-NEW-STREET-POSSIBLE-PO-3
               when OTHER        perform BUILD-NEW-STREET-NORMAL-WORD
           end-evaluate
           exit.

      *---------------------------------------------------------------*
       BUILD-NEW-STREET-POSSIBLE-PO-1.
           move 'POB ' to RDPA-ADR2-CNTL
           move 'P.O. Box '  to RDPA-ADR2-DATA(X2:9)
           add 9 to X2
           subtract RDPA-RESULT from RDPA-RESULT
           exit.

      *---------------------------------------------------------------*
       BUILD-NEW-STREET-POSSIBLE-PO-2.
           add X1 to 1 giving X3
           if  PRS-POSITION(X3) > 0
           and PRS-SIZE(X3) > 0
               if  PRS-BUFFER(PRS-POSITION(X3):4) = 'box '
                   move 'POB ' to RDPA-ADR2-CNTL
                   move 'P.O. Box '  to RDPA-ADR2-DATA(X2:9)
                   add 1 to X1
                   add 9 to X2
                   subtract RDPA-RESULT from RDPA-RESULT
               else
                   if  PRS-BUFFER(PRS-POSITION(X3):1) is NUMERIC
                       move 'POB ' to RDPA-ADR2-CNTL
                       move 'P.O. Box '  to RDPA-ADR2-DATA(X2:9)
                       add 9 to X2
                       subtract RDPA-RESULT from RDPA-RESULT
                   else
                       move 'PO? ' to RDPA-ADR2-CNTL
                       perform BUILD-NEW-STREET-NORMAL-WORD
                       subtract RDPA-RESULT from RDPA-RESULT
                   end-if
               end-if
           end-if
           exit.

      *---------------------------------------------------------------*
       BUILD-NEW-STREET-POSSIBLE-PO-3.
           add X1 to 1 giving X3
           if  PRS-POSITION(X3) > 0
           and PRS-SIZE(X3) > 0
               if  PRS-BUFFER(PRS-POSITION(X3):2) = 'o '
               or  PRS-BUFFER(PRS-POSITION(X3):3) = 'o. '
               or  PRS-BUFFER(PRS-POSITION(X3):7) = 'office '
                   add 1 to X3
                   if  PRS-BUFFER(PRS-POSITION(X3):4) = 'box '
                   and PRS-POSITION(X3) > 0
                   and PRS-SIZE(X3) > 0
                       move 'POB ' to RDPA-ADR2-CNTL
                       move 'P.O. Box '  to RDPA-ADR2-DATA(X2:9)
                       add 2 to X1
                       add 9 to X2
                       subtract RDPA-RESULT from RDPA-RESULT
                   else
                       if  PRS-BUFFER(PRS-POSITION(X3):1) is NUMERIC
                           move 'POB ' to RDPA-ADR2-CNTL
                           move 'P.O. Box '  to RDPA-ADR2-DATA(X2:9)
                           add 9 to X2
                           subtract RDPA-RESULT from RDPA-RESULT
                       else
                           move 'PO? ' to RDPA-ADR2-CNTL
                           perform BUILD-NEW-STREET-NORMAL-WORD
                           subtract RDPA-RESULT from RDPA-RESULT
                       end-if
                   end-if
               else
                   perform BUILD-NEW-STREET-NORMAL-WORD
               end-if
           end-if
           exit.

      *---------------------------------------------------------------*
       BUILD-NEW-STREET-NORMAL-WORD.
      *>   Test for possible word substitution...
           move SPACES to WORD-12
           if  PRS-SIZE(X1) < 13
               move PRS-BUFFER(PRS-POSITION(X1):PRS-SIZE(X1))
                 to WORD-12
               perform BUILD-NEW-STREET-SUB-WORD-ALL
           end-if

           if  WORD-12 = SPACES
               move PRS-BUFFER(PRS-POSITION(X1):PRS-SIZE(X1))
                 to RDPA-ADR2-DATA(X2:PRS-SIZE(X1))
               inspect RDPA-ADR2-DATA(X2:1)
                   converting LOWER-CASE to UPPER-CASE
               add PRS-SIZE(X1) to X2
               add 1              to X2
               subtract RDPA-RESULT from RDPA-RESULT
           else
               move WORD-12(1:WORD-SIZE)
                 to RDPA-ADR2-DATA(X2:WORD-SIZE)
               if  PRS-POSITION(X1) = 1
                   inspect RDPA-ADR2-DATA(X2:1)
                       converting LOWER-CASE to UPPER-CASE
               end-if
               add WORD-SIZE to X2
               add 1         to X2
               subtract RDPA-RESULT from RDPA-RESULT
           end-if
           exit.

      *---------------------------------------------------------------*
       BUILD-NEW-STREET-SUB-WORD-ALL.
           evaluate WORD-12
             when 'ave         ' move 'Avenue    '   to WORD-12
                                 add  6  to ZERO giving WORD-SIZE
             when 'ave.        ' move 'Avenue    '   to WORD-12
                                 add  6  to ZERO giving WORD-SIZE
             when 'bl          ' move 'Blvd      '   to WORD-12
                                 add  4  to ZERO giving WORD-SIZE
             when 'bl.         ' move 'Blvd      '   to WORD-12
                                 add  4  to ZERO giving WORD-SIZE
             when 'de          ' move 'de        '   to WORD-12
                                 add  2  to ZERO giving WORD-SIZE
             when 'la          ' move 'la        '   to WORD-12
                                 add  2  to ZERO giving WORD-SIZE
             when 'of          ' move 'of        '   to WORD-12
                                 add  2  to ZERO giving WORD-SIZE
             when 'and         ' move 'and       '   to WORD-12
                                 add  3  to ZERO giving WORD-SIZE
             when 'the         ' move 'the       '   to WORD-12
                                 add  3  to ZERO giving WORD-SIZE
             when 'macdougal   ' move 'MacDougal'    to WORD-12
                                 add  9  to ZERO giving WORD-SIZE
             when OTHER          move SPACES to WORD-12
           end-evaluate
           exit.

      *****************************************************************
       CALCULATE-BUFFER-SIZE-01.
           add PRS-NUMBER-OF-ITEMS to ZERO giving X1
           add PRS-POSITION(X1) to PRS-SIZE(X1) giving RDPA-ADR1-SIZE
           subtract 1 from RDPA-ADR1-SIZE
           exit.

      *****************************************************************
       CALCULATE-BUFFER-SIZE-02.
           if  RDPA-ADR2-DATA = SPACES
               move ZERO to RDPA-ADR2-SIZE
           else
               add length of RDPA-ADR2-DATA to ZERO giving X1
               add length of RDPA-ADR2-DATA to ZERO giving X3
               perform  until X1 not = X3
                           or X1     < 4
                 divide X3 by 2 giving X1
                 if  X1 > 0
                     if  RDPA-ADR2-DATA(X1 + 1:X3 - X1) = SPACES
                         add X1 to ZERO giving X3
                     end-if
                 end-if
               end-perform
               add 1 to ZERO giving RDPA-ADR2-SIZE
               move ZERO to X2
               perform until X2 = X3
                 add 1 to X2
                 if  RDPA-ADR2-DATA(X2:1) not = SPACE
                     add X2 to ZERO giving RDPA-ADR2-SIZE
                 end-if
               end-perform
           end-if
           exit.

      *****************************************************************
       COMPRESS-MULTIPLE-SPACES.
           move SPACES to RDPA-ADR2-DATA
           add 1 to ZERO giving X1
           add 1 to ZERO giving X2
           perform until PRS-SIZE(X1) = 0
                      or PRS-POSITION(X1) = 0
                      or X1       > PRS-TABLE-MAX
                      or X1       > PRS-NUMBER-OF-ITEMS
               move PRS-BUFFER(PRS-POSITION(X1):PRS-SIZE(X1))
                 to RDPA-ADR2-DATA(X2:PRS-SIZE(X1))
               add X2 to ZERO giving PRS-POSITION(X1)
               add PRS-SIZE(X1) to X2
               add 1 to X2
               add 1 to X1
           end-perform
           move SPACES to PRS-BUFFER
           move RDPA-ADR2-DATA to PRS-BUFFER
           move SPACES to RDPA-ADR2-DATA
           exit.

      *---------------------------------------------------------------*
       POST-TABLE-ITEM.
           move 'Item-nnnn, Offset-nnnn, Length-nnnn, Parameter - '
             to MESSAGE-TEXT(1:49)
           move X1 to MESSAGE-TEXT(6:4)
           move PRS-POSITION(X1) to MESSAGE-TEXT(19:4)
           move PRS-SIZE(X1) to MESSAGE-TEXT(32:4)
           if  PRS-SIZE(X1) < 20
               move PRS-BUFFER(PRS-POSITION(X1):PRS-SIZE(X1))
                 to MESSAGE-TEXT(50:PRS-SIZE(X1))
           else
               move PRS-BUFFER(PRS-POSITION(X1):19)
                 to MESSAGE-TEXT(50:19)
           end-if
           perform Z-DISPLAY-CONSOLE-MESSAGE
           exit.

      *****************************************************************
       PROCESS-STREET-ADDRESS.
           if  RDPA-ADR1-DATA = SPACES
           or  RDPA-ADR1-DATA = LOW-VALUES
               perform Z-ABEND-INVALID-INPUT
           else
               perform ADDR-FUNCTION-PARSE
               perform CALCULATE-BUFFER-SIZE-01
               if  PRS-STATUS = 0
      *            perform ADDR-FUNCTION-DISPLAY-WORDS
                   perform COMPRESS-MULTIPLE-SPACES
                   perform PROCESS-STREET-ADDRESS-100
                   perform CALCULATE-BUFFER-SIZE-02
               else
                   move 'Parsing Error' to RDPA-ADR2-DATA
                   move RDPA-ADR2-DATA to MESSAGE-TEXT
                   perform Z-DISPLAY-CONSOLE-MESSAGE
               end-if

           end-if.
           exit.

      *---------------------------------------------------------------*
       PROCESS-STREET-ADDRESS-100.
           perform BUILD-NEW-STREET-ADDRESS
           if  RDPA-ADR2-CNTL = 'UNK '
           and RDPA-ADR2-DATA not = SPACES
               if  RDPA-ADR1-DATA = RDPA-ADR2-DATA
                   move 'AOK ' to RDPA-ADR2-CNTL
                   subtract RDPA-RESULT from RDPA-RESULT
               else
                   move 'MOD ' to RDPA-ADR2-CNTL
                   subtract RDPA-RESULT from RDPA-RESULT
               end-if
               subtract RDPA-RESULT from RDPA-RESULT
           end-if
           exit.

      *****************************************************************
      * The following Z-Routines perform administrative functions     *
      * for this program.                                             *
      *****************************************************************
      * ABEND the program, post a message to the console and issue    *
      * a STOP RUN.                                                   *
      *****************************************************************
       Z-ABEND-PROGRAM.
           if  MESSAGE-TEXT not = SPACES
               perform Z-DISPLAY-CONSOLE-MESSAGE
           end-if
           move 'PROGRAM-IS-ABENDING...'  to MESSAGE-TEXT
           perform Z-DISPLAY-CONSOLE-MESSAGE
           add 12 to ZERO giving RETURN-CODE
           STOP RUN.
      *    exit.

      *---------------------------------------------------------------*
       Z-ABEND-INVALID-REQUEST.
           add 18 to ZERO giving RDPA-RESULT
           move 'ERR ' to RDPA-ADR2-CNTL
           move 'Call to SimoROAD with invalid request'
             to RDPA-ADR2-DATA
           exit.

      *---------------------------------------------------------------*
       Z-ABEND-INVALID-INPUT.
           add 20 to ZERO giving RDPA-RESULT
           move 'ERR ' to RDPA-ADR2-CNTL
           move 'Call to SimoROAD with blank input address'
             to RDPA-ADR2-DATA
           exit.

      *****************************************************************
      * Display CONSOLE messages...                                   *
      *****************************************************************
       Z-DISPLAY-CONSOLE-MESSAGE.
           if MESSAGE-TEXT-2 = SPACES
               display MESSAGE-BUFFER(1:79) upon console
           else
               display MESSAGE-BUFFER upon console
           end-if
           move all SPACES to MESSAGE-TEXT
           exit.

      *****************************************************************
       Z-POST-COPYRIGHT.
           display SIM-TITLE     upon console
           display SIM-COPYRIGHT upon console
           exit.
      *****************************************************************
      *      This example is provided by SimoTime Technologies        *
      *        Our e-mail address is: helpdesk@simotime.com           *
      *     Also, visit our Web Site at http://www.simotime.com       *
      *****************************************************************
