       IDENTIFICATION DIVISION.
       PROGRAM-ID.  CCSJCLC1.
       AUTHOR.      SIMOTIME TECHNOLOGIES.
      *****************************************************************
      * Copyright (C) 1987-2015 SimoTime Technologies.                *
      *                                                               *
      * All rights reserved.  Unpublished, all rights reserved under  *
      * copyright law and international treaty.  Use of a copyright   *
      * notice is precautionary only and does not imply publication   *
      * or disclosure.                                                *
      *                                                               *
      * Permission to use, copy, modify and distribute this software  *
      * for any non-commercial purpose and without fee is hereby      *
      * granted, provided the SimoTime copyright notice appear on all *
      * copies of the software. The SimoTime name or Logo may not be  *
      * used in any advertising or publicity pertaining to the use    *
      * of the software without the written permission of SimoTime    *
      * Technologies.                                                 *
      *                                                               *
      * Permission to use, copy, modify and distribute this software  *
      * for any commercial purpose requires a fee to be paid to       *
      * SimoTime Technologies. Once the fee is received by SimoTime   *
      * the latest version of the software will be delivered and a    *
      * license will be granted for use within an enterprise,         *
      * provided the SimoTime copyright notice appear on all copies   *
      * of the software. The SimoTime name or Logo may not be used    *
      * in any advertising or publicity pertaining to the use of the  *
      * software without the written permission of SimoTime           *
      * Technologies.                                                 *
      *                                                               *
      * SimoTime Technologies makes no warranty or representations    *
      * about the suitability of the software for any purpose. It is  *
      * provided "AS IS" without any expressed or implied warranty,   *
      * including the implied warranties of merchantability, fitness  *
      * for a particular purpose and non-infringement. SimoTime       *
      * Technologies shall not be liable for any direct, indirect,    *
      * special or consequential damages resulting from the loss of   *
      * use, data or projects, whether in an action of contract or    *
      * tort, arising out of or in connection with the use or         *
      * performance of this software                                  *
      *                                                               *
      * SimoTime Technologies                                         *
      * 15 Carnoustie Drive                                           *
      * Novato, CA 94949-5849                                         *
      * 415.883.6565                                                  *
      *                                                               *
      * RESTRICTED RIGHTS LEGEND                                      *
      * Use, duplication, or disclosure by the Government is subject  *
      * to restrictions as set forth in subparagraph (c)(1)(ii) of    *
      * the Rights in Technical Data and Computer Software clause at  *
      * DFARS 52.227-7013 or subparagraphs (c)(1) and (2) of          *
      * Commercial  Computer Software - Restricted Rights  at 48      *
      * CFR 52.227-19, as applicable.  Contact SimoTime Technologies, *
      * 15 Carnoustie Drive, Novato, CA 94949-5849.                   *
      *                                                               *
      *****************************************************************
      *      This program is provided by SimoTime Technologies        *
      *        Our e-mail address is: helpdesk@simotime.com           *
      *     Also, visit our Web Site at http://www.simotime.com       *
      *****************************************************************
      *
      * MAINTENANCE
      * -----------
      * 1992/11/27 Simmons, Created program.
      * 1997/03/17 Simmons, Updated JCL being submitted.
      *
      *****************************************************************
      * DESCRIPTION
      * -----------
      * This program will submit a job to the internal reader (INTRDR)
      * using the EXEC CICS SPOOL commands.
      *****************************************************************
       ENVIRONMENT DIVISION.
      *---------------------------------------------------------------*
       CONFIGURATION SECTION.
       SOURCE-COMPUTER.     ES-MSS.
       OBJECT-COMPUTER.     ES-MSS.

      *****************************************************************
       DATA DIVISION.
      *---------------------------------------------------------------*
       WORKING-STORAGE SECTION.
       01  WS-PROGRAM-LOCATION         PIC X(04).

       01  WS-MSG-TEXT                 PIC X(60).
       01  WS-MSG-LEN                  PIC S9(04) COMP VALUE +60.

       01  WORK-DATE.
           05  WORK-DATE-CC    pic X(02).
           05  WORK-DATE-YY    pic 9(02).
           05  WORK-DATE-MM    pic X(02).
           05  WORK-DATE-DD    pic 9(02).
       01  WORK-TIME.
           05  WORK-TIME-HH    pic X(02).
           05  WORK-TIME-MM    pic X(02).
           05  WORK-TIME-SS    pic X(02).
           05  WORK-TIME-TT    pic X(02).

       01  EDIT-DATE.
           05  EDIT-DATE-CC    pic X(02).
           05  EDIT-DATE-YY    pic 9(02).
           05  filler          pic X       value '/'.
           05  EDIT-DATE-MM    pic X(02).
           05  filler          pic X       value '/'.
           05  EDIT-DATE-DD    pic 9(02).
       01  EDIT-TIME.
           05  EDIT-TIME-HH    pic X(02).
           05  filler          pic X       value ':'.
           05  EDIT-TIME-MM    pic X(02).
           05  filler          pic X       value ':'.
           05  EDIT-TIME-SS    pic X(02).
           05  filler          pic X       value ':'.
           05  EDIT-TIME-TT    pic X(02).

       01  WS-BEGIN-MSG                PIC X(40)   VALUE
           'CCSJCLC1 - TRANSACTION STARTED          '.
       01  WS-END-MSG                  PIC X(50)   VALUE
           'CCSJCLC1 - Submit JCL to INTRDR from CICS         '.
       01  WS-ERR-LOAD-PROGRAM         PIC X(50)   VALUE
           'CCSJCLC1 - TRAN FAILED - JCL to INTRDR FAILED     '.

       01  MEMBER-NAME         PIC X(8)    VALUE 'CSSJCLC1'.

       01  SPOOL-FIELDS.
           03  SPOOL-TOKEN     PIC X(8)  VALUE LOW-VALUES.
           03  SPOOL-NODE      PIC X(8)  VALUE 'SIMOCICS'.
           03  SPOOL-USERID    PIC X(8)  VALUE 'INTRDR  '.
           03  SPOOL-CLASS     PIC X     VALUE 'A'.

       01  CICS-RESP           PIC X(04).
       01  WS-RESP2            PIC X(04).
       01  CICS-80             PIC X(80).

       01  JOB-ONE.
           05  filler  pic X(60) value
       '//CCSRDRJ9 JOB SIMOTIME,CLASS=R,MSGCLASS=0,NOTIFY=CSIP1     '.
           05  filler  pic X(60) value
       '//QSAMDELT EXEC PGM=IEFBR14                                 '.
           05  filler  pic X(60) value
       '//SYSUT2   DD  DSN=SIMOTIME.CICSAOK.RDRTEST1,               '.
           05  filler  pic X(60) value
       '//             DISP=(MOD,DELETE,DELETE),                    '.
           05  filler  pic X(60) value
       '//             STORCLAS=MFI,                                '.
           05  filler  pic X(60) value
       '//             SPACE=(TRK,5),                               '.
           05  filler  pic X(60) value
       '//             DCB=(RECFM=FB,LRECL=80,DSORG=PS)             '.
           05  filler  pic X(60) value
       '//*                                                         '.
           05  filler  pic X(60) value
       '//QCRTDIN1 EXEC PGM=IEBGENER                                '.
           05  filler  pic X(60) value
       '//SYSPRINT DD  SYSOUT=*                                     '.
           05  filler  pic X(60) value
       '//SYSIN    DD  DUMMY                                        '.
           05  filler  pic X(60) value
       '//* :....1....:....2....:....3....:....4....:....5....:....6'.
           05  filler  pic X(60) value
       '//SYSUT1   DD  *                                            '.
      *    05  filler  pic X(60) value
      *'CCSRDRC1 Job Submission from CICS...                        '.
           05  DATA-RECORD.
               10  filler  pic X(8)    value 'CCSRDRC1'.
               10  filler  pic X       value SPACE.
               10  D-DATE  pic X(10)   value SPACES.
               10  filler  pic X       value SPACE.
               10  D-TIME  pic X(11)   value SPACES.
               10  filler  pic X       value SPACE.
               10  filler  pic X(23)   value 'Job Submitted from CICS'.
               10  filler  pic X(5)    value SPACES.
           05  filler  pic X(60) value
       '/*                                                          '.
           05  filler  pic X(60) value
       '//SYSUT2   DD  DSN=SIMOTIME.CICSAOK.RDRTEST1,               '.
           05  filler  pic X(60) value
       '//             DISP=(NEW,CATLG,DELETE),                     '.
           05  filler  pic X(60) value
       '//             STORCLAS=MFI,                                '.
           05  filler  pic X(60) value
       '//             SPACE=(TRK,5),                               '.
           05  filler  pic X(60) value
       '//             DCB=(RECFM=FB,LRECL=80,DSORG=PS)             '.
           05  filler  pic X(60) value
       '//                                                          '.

       01  WX-1            pic 9(5)    value 0.

      *****************************************************************
       LINKAGE SECTION.
       01  DFHCOMMAREA                     PIC X(316).

       01  TBLECL-GROUP.
           05  filler          PIC X(300).

      *****************************************************************
       PROCEDURE DIVISION.
      *    Display console message - start processing
           move WS-BEGIN-MSG   to WS-MSG-TEXT.
           perform Z-SEND-MSG-TEXT.

      *    Submit JCL to INTRDR
           if  EIBRESP NOT = DFHRESP (NORMAL)
               move WS-ERR-LOAD-PROGRAM to WS-MSG-TEXT
               perform Z-SEND-MSG-TEXT
               go to Z-RETURN-TO-CICS.

               perform Z-GET-DATE-AND-TIME
               perform INTRDR-SPOOL-OPEN
               move EDIT-DATE to D-DATE
               move EDIT-TIME to D-TIME
               add 1 to ZERO giving WX-1
               perform 21 times
                   move JOB-ONE(WX-1:60) to CICS-80
                   perform INTRDR-SPOOL-WRITE
                   add 60 to WX-1
               end-perform
               perform INTRDR-SPOOL-CLOSE

           move WS-END-MSG to WS-MSG-TEXT.
           perform Z-SEND-MSG-TEXT.

           go to Z-RETURN-TO-CICS.

      *****************************************************************
       INTRDR-SPOOL-OPEN.
           EXEC CICS SPOOLOPEN OUTPUT
                     TOKEN  (SPOOL-TOKEN)
                     USERID (SPOOL-USERID)
                     NODE   (SPOOL-NODE)
                     CLASS  (SPOOL-CLASS)
                     PUNCH
                     RESP   (CICS-RESP)
                     RESP2  (WS-RESP2)
           END-EXEC
           exit.

      *****************************************************************
       INTRDR-SPOOL-WRITE.
           EXEC CICS SPOOLWRITE
                     TOKEN (SPOOL-TOKEN)
                     FROM  (CICS-80)
                     RESP  (CICS-RESP)
                     RESP2 (WS-RESP2)
           END-EXEC.
           exit.

      *****************************************************************
       INTRDR-SPOOL-CLOSE.
           EXEC CICS SPOOLCLOSE
                     TOKEN (SPOOL-TOKEN)
                     RESP  (CICS-RESP)
                     RESP2 (WS-RESP2)
           END-EXEC
           exit.

      *****************************************************************
       Z-SEND-MSG-TEXT.
      *    Send console message
           EXEC CICS SEND TEXT
                     FROM ( WS-MSG-TEXT )
                     LENGTH( WS-MSG-LEN )
                     ERASE
                     FREEKB
                     END-EXEC.
           exit.

      *****************************************************************
       Z-RETURN-TO-CICS.
      *    Program return to cics
           EXEC CICS RETURN END-EXEC.

      *****************************************************************
       Z-GET-DATE-AND-TIME.
           accept WORK-DATE from DATE YYYYMMDD
           accept WORK-TIME from TIME

           move 'ccyy/mm/dd' to EDIT-DATE
           move WORK-DATE-CC to EDIT-DATE-CC
           move WORK-DATE-YY to EDIT-DATE-YY
           move WORK-DATE-MM to EDIT-DATE-MM
           move WORK-DATE-DD to EDIT-DATE-DD

           move 'hh:mm:ss:dd' to EDIT-TIME
           move WORK-TIME-HH  to EDIT-TIME-HH
           move WORK-TIME-MM  to EDIT-TIME-MM
           move WORK-TIME-SS  to EDIT-TIME-SS
           move WORK-TIME-TT  to EDIT-TIME-TT

           exit.
