@echo OFF
rem  * *******************************************************************
rem  *               CSDPCTE1.CMD - a Windows Command File               *
rem  *         This program is provided by SimoTime Technologies         *
rem  *           (C) Copyright 1987-2016 All Rights Reserved             *
rem  *             Web Site URL:   http://www.simotime.com               *
rem  *                   e-mail:   helpdesk@simotime.com                 *
rem  * *******************************************************************
rem  *
rem  * Text   - Glance at the CSD Information for PCTs.
rem  * Author - SimoTime Technologies
rem  * Date   - January 24, 2006
rem  *
rem  * The 1st step will Prepare the environment.
rem  *
rem  * The 2nd step will extract PCT information from DFHDRDAT.
rem  *
rem  * The 3rd step will post PCT information to a CSV File.
rem  *
rem  * *******************************************************************
rem  * Step 1 of 3,  Prepare the environment...
rem  *
     set CmdName=CSDPCTE1
     call ..\Env1BASE %CmdName%
     set JobStatus=0000
     if "%SYSLOG%" == "" set syslog=c:\SimoLIBR\LOGS\SimoTime.LOG
     call SimoNOTE "*******************************************************%CmdName%"
     call SimoNOTE "Starting JobName %CmdName%, User is %USERNAME%"
     call SimoNOTE "Identify JobStep DeleteQSAM"
     set RDTFILE2=%BaseLib1%\CSD\SIMOTIME.PCT.RDTFILE2.TXT
     if exist %RDTFILE2% del %RDTFILE2%
rem  *
rem  * *******************************************************************
rem  * Step 2 of 3, Get PCT Information from RDO File...
rem  *
     casrdtex /o%RDTFILE2% /gSIMOGRPA /x /e /ip"C:\SIMOSAM1\DEVL\SYS1\CONFIG"
rem  *
     if exist %RDTFILE2% goto :PostToCSV
     set JobStatus=0020
     goto :EojNok
rem  *
rem  * *******************************************************************
rem  * Step 3 of 3, Post PCT Information to a CSV File...
rem  *
:PostToCSV
     set CSDGETD1=%RDTFILE2%
     set CSDPUTD1=%BaseLib1%\CSD\SIMOTIME.PCT.SIMOCICA.CSV
     run CSDPCTC1
rem  *
rem  * *******************************************************************
rem  *
:EojAok
     call SimoNOTE "Produced %CSDPUTD1%"
     call SimoNOTE "Finished JobName %CmdName%, Job Status is %JobStatus%"
     goto :End
:EojNok
     call SimoNOTE "ABENDING JobName %CmdName%, Job Status is %JobStatus%"
:End
     call SimoNOTE "Conclude SysLog is %SYSLOG%"
     if not "%1" == "nopause" pause
