       IDENTIFICATION DIVISION.
       PROGRAM-ID.    NUMPRTC1.
       AUTHOR.        SIMOTIME TECHNOLOGIES.
      *****************************************************************
      * Copyright (C) 1987-2019 SimoTime Technologies.                *
      *                                                               *
      * All rights reserved.  Unpublished, all rights reserved under  *
      * copyright law and international treaty.  Use of a copyright   *
      * notice is precautionary only and does not imply publication   *
      * or disclosure.                                                *
      *                                                               *
      * Permission to use, copy, modify and distribute this software  *
      * for any  purpose requires a fee to be paid to SimoTime        *
      * Technologies. Once the fee is received by SimoTime the latest *
      * version of the software will be delivered and a license will  *
      * be granted for use within an enterprise, provided the         *
      * SimoTime copyright notice appear on all copies of the         *
      * software. The SimoTime name or Logo may not be used in any    *
      * advertising or publicity pertaining to the use of the         *
      * software without the written permission of SimoTime           *
      * Technologies.                                                 *
      *                                                               *
      * SimoTime Technologies makes no warranty or representations    *
      * about the suitability of the software for any purpose. It is  *
      * provided "AS IS" without any expressed or implied warranty,   *
      * including the implied warranties of merchantability, fitness  *
      * for a particular purpose and non-infringement. SimoTime       *
      * Technologies shall not be liable for any direct, indirect,    *
      * special or consequential damages resulting from the loss of   *
      * use, data or projects, whether in an action of contract or    *
      * tort, arising out of or in connection with the use or         *
      * performance of this software                                  *
      *                                                               *
      * SimoTime Technologies                                         *
      * 15 Carnoustie Drive                                           *
      * Novato, CA 94949-5849                                         *
      * 415.883.6565                                                  *
      *                                                               *
      * RESTRICTED RIGHTS LEGEND                                      *
      * Use, duplication, or disclosure by the Government is subject  *
      * to restrictions as set forth in subparagraph (c)(1)(ii) of    *
      * the Rights in Technical Data and Computer Software clause at  *
      * DFARS 52.227-7013 or subparagraphs (c)(1) and (2) of          *
      * Commercial  Computer Software - Restricted Rights  at 48      *
      * CFR 52.227-19, as applicable.  Contact SimoTime Technologies, *
      * 15 Carnoustie Drive, Novato, CA 94949-5849.                   *
      *                                                               *
      *****************************************************************
      *      This program is provided by SimoTime Technologies        *
      *        Our e-mail address is: helpdesk@simotime.com           *
      *     Also, visit our Web Site at http://www.simotime.com       *
      *****************************************************************
      * Source Member: NUMPRTC1.CBL
      *****************************************************************
      *
      * NUMPRTC1 - Print text and various numeric field formats.
      *
      * DESCRIPTION
      * -----------
      * This set of programs is used to show the various numeric
      * formats and how to edit for printing.
      *
      * This program illustrates the use of some of the commonly
      * used numeric formats such as the display format(actual digits),
      * the packed format (COMP-3) and the binary (COMP) formats.
      *
      * The COBOL programs are compiled with the ASSIGN(EXTERNAL)
      * directive. This provides for external file mapping of file
      * names.
      *
      * When running with Net Express the IBMCOMP an NOTRUNC directives
      * will be required to maintain compatability with the mainframe
      * format and field sizes for binary fields. The filetype(11) and
      * ADV directive will be required to maintain the mainframe print
      * format for the output file.
      *
      * This technique provides for the use of a single COBOL source
      * program that will run on OS/390, Windows or Unix.
      *
      * This program will run on a Personal Computer with Windows
      * and Micro Focus Net Express or Mainframe Express.
      *
      * This program will also run on an IBM Mainframe.
      *
       ENVIRONMENT DIVISION.
       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
           SELECT ITEMMAST-FILE  ASSIGN TO       ITEMMAST
                  ORGANIZATION  IS INDEXED
                  ACCESS MODE   IS SEQUENTIAL
                  RECORD KEY    IS ITEM-NUMBER
                  FILE STATUS   IS ITEMMAST-STATUS.
           SELECT ITMPRINT-FILE  ASSIGN TO       ITMPRINT
                  ORGANIZATION  IS SEQUENTIAL
                  ACCESS MODE   IS SEQUENTIAL
                  FILE STATUS   IS ITMPRINT-STATUS.

      *****************************************************************
       DATA DIVISION.
       FILE SECTION.
       FD  ITEMMAST-FILE
           DATA RECORD    IS ITEM-RECORD.
       COPY ITEMCB01.

       FD  ITMPRINT-FILE
           DATA RECORD    IS ITMPRINT-REC
           .
       01  ITMPRINT-REC.
           05  ITMPRINT-DATA-01 PIC X(00132).

      *****************************************************************
      * This program was created using the SYSMASK1.TXT file as input.*
      * The SYSMASK1 provides for the sequential reading of the input *
      * file and the sequential writing of the output file.           *
      *                                                               *
      * If the output file is indexed then the input file must be in  *
      * sequence by the field that will be used to provide the key    *
      * for the output file.                                          *
      *                                                               *
      * If the key field is not in sequence then refer to SYSMASK2    *
      * to provide for a random add or update of the indexed file.    *
      *                                                               *
      * This program mask will have the ASCII/EBCDIC table inserted   *
      * for use by the /TRANSLATE function of SimoZAPS.               *
      *                                                               *
      * For additional information contact SimoTime Technologies.     *
      *                                                               *
      *        Our e-mail address is: helpdesk@simotime.com           *
      *     Also, visit our Web Site at http://www.simotime.com       *
      *****************************************************************
       WORKING-STORAGE SECTION.
       01  SIM-TITLE.
           05  T1 pic X(11) value '* NUMPRTC1 '.
           05  T2 pic X(34) value 'Sample Printing of Item File      '.
           05  T3 pic X(10) value 'v08.02.26 '.
           05  T4 pic X(24) value ' http://www.simotime.com'.
       01  SIM-COPYRIGHT.
           05  C1 pic X(11) value '* NUMPRTC1 '.
           05  C2 pic X(20) value 'Copyright 1987-2019 '.
           05  C3 pic X(28) value '   SimoTime Technologies    '.
           05  C4 pic X(20) value ' All Rights Reserved'.

       01  ITEMMAST-STATUS.
           05  ITEMMAST-STATUS-L     pic X.
           05  ITEMMAST-STATUS-R     pic X.
       01  ITEMMAST-EOF              pic X       value 'N'.
       01  ITEMMAST-OPEN-FLAG        pic X       value 'C'.

       01  ITMPRINT-STATUS.
           05  ITMPRINT-STATUS-L     pic X.
           05  ITMPRINT-STATUS-R     pic X.
       01  ITMPRINT-EOF              pic X       value 'N'.
       01  ITMPRINT-OPEN-FLAG        pic X       value 'C'.


      *****************************************************************
      * The following buffers are used to create a four-byte status   *
      * code that may be displayed.                                   *
      *****************************************************************
       01  IO-STATUS.
           05  IO-STAT1            pic X.
           05  IO-STAT2            pic X.
       01  IO-STATUS-04.
           05  IO-STATUS-0401      pic 9     value 0.
           05  IO-STATUS-0403      pic 999   value 0.
       01  TWO-BYTES-BINARY        pic 9(4)  BINARY.
       01  TWO-BYTES-ALPHA         redefines TWO-BYTES-BINARY.
           05  TWO-BYTES-LEFT      pic X.
           05  TWO-BYTES-RIGHT     pic X.

      *****************************************************************
      * Message Buffer used by the Z-DISPLAY-MESSAGE-TEXT routine.    *
      *****************************************************************
       01  MESSAGE-BUFFER.
           05  MESSAGE-HEADER      pic X(11)   value '* NUMPRTC1 '.
           05  MESSAGE-TEXT.
               10  MESSAGE-TEXT-1  pic X(68)   value SPACES.
               10  MESSAGE-TEXT-2  pic X(188)  value SPACES.

      *****************************************************************
       01  PROGRAM-NAME            pic X(8)     value 'NUMPRTC1'.

       01  APPL-RESULT             pic S9(9)    comp.
           88  APPL-AOK            value 0.
           88  APPL-EOF            value 16.

       01  LINE-COUNT              pic 9(5)    value 66.

       01  PRINT-HDR-1-LINE.
           05  FILLER  pic X(57) value SPACES.
           05  FILLER  pic X(17) value 'Item Master File'.

       01  PRINT-HDR-2-LINE.
           05  FILLER  pic X(60) value SPACES.
           05  FILLER  pic X(10) value 'Price List'.

       01  PRINT-HDR-3-LINE.
           05  FILLER  pic X(12) value '      Number'.
           05  FILLER  PIC X     value SPACE.
           05  FILLER  pic X(11) value 'Description'.
           05  FILLER  PIC X(45) value SPACES.
           05  FILLER  pic X(11) value 'Price'.
           05  FILLER  PIC X     value SPACE.
           05  FILLER  pic X(11) value 'Available'.

       01  PRINT-DTL-1-LINE.
           05  P-ITEM-NUMBER          PIC X(12).
           05  FILLER                 PIC X        value SPACE.
           05  P-ITEM-DESCRIPTION     PIC X(48).
           05  FILLER                 PIC X        value SPACE.
           05  P-ITEM-PRICE           PIC Z,ZZZ,ZZZ.99-.
           05  FILLER                 PIC X(6)     value SPACE.
           05  P-QTY-AVAILABLE        PIC Z,ZZZ,ZZ9+.

       01  ITEMMAST-TOTAL.
           05  ITEMMAST-RDR  pic 9(9)  value 0.
           05  filler        pic X(3)  value ' - '.
           05  filler        pic X(23) value 'Line count for ITEMMAST'.
       01  ITMPRINT-TOTAL.
           05  ITMPRINT-ADD  pic 9(9)  value 0.
           05  filler        pic X(3)  value ' - '.
           05  filler        pic X(23) value 'Line count for ITMPRINT'.


      *****************************************************************
       PROCEDURE DIVISION.
           perform Z-POST-COPYRIGHT
           perform ITEMMAST-OPEN
           perform ITMPRINT-OPEN

           perform until ITEMMAST-STATUS not = '00'
               perform ITEMMAST-READ
               if  ITEMMAST-STATUS = '00'
                   if  LINE-COUNT > 60
                       move SPACES           to ITMPRINT-REC
                       move PRINT-HDR-1-LINE to ITMPRINT-REC
                       perform ITMPRINT-WRITE-HDR-1
                       move PRINT-HDR-2-LINE to ITMPRINT-REC
                       perform ITMPRINT-WRITE
                       move PRINT-HDR-3-LINE to ITMPRINT-REC
                       perform ITMPRINT-WRITE
                       add 3 to ZERO giving LINE-COUNT
                   end-if
                   add 1 to ITEMMAST-RDR
                   perform BUILD-PRINT-LINE
                   perform ITMPRINT-WRITE
                   if  ITMPRINT-STATUS = '00'
                       add 1 to ITMPRINT-ADD
                       add 1 to LINE-COUNT
                   end-if
               end-if
           end-perform

           move ITEMMAST-TOTAL to MESSAGE-TEXT
           perform Z-DISPLAY-MESSAGE-TEXT

           move ITMPRINT-TOTAL to MESSAGE-TEXT
           perform Z-DISPLAY-MESSAGE-TEXT

           if  APPL-EOF
               move 'is Complete...' to MESSAGE-TEXT
           else
               move 'is ABENDING...' to MESSAGE-TEXT
           end-if
           perform Z-DISPLAY-MESSAGE-TEXT

           perform ITMPRINT-CLOSE
           perform ITEMMAST-CLOSE
           GOBACK.

      *****************************************************************
       BUILD-PRINT-LINE.
      *>   TransCOPY...
           move ITEM-NUMBER to P-ITEM-NUMBER
           inspect P-ITEM-NUMBER replacing leading ZEROES by SPACE
           move ITEM-DESCRIPTION to P-ITEM-DESCRIPTION
           move ITEM-PRICE to P-ITEM-PRICE
           subtract ITEM-QTY-ALLOCATED from ITEM-QTY-ONHAND
                    giving P-QTY-AVAILABLE
           move SPACES to ITMPRINT-REC
           move PRINT-DTL-1-LINE to ITMPRINT-REC
           exit.

      *****************************************************************
      * I/O Routines for the INPUT File...                            *
      *****************************************************************
       ITEMMAST-CLOSE.
           add 8 to ZERO giving APPL-RESULT.
           close ITEMMAST-FILE
           if  ITEMMAST-STATUS = '00'
               subtract APPL-RESULT from APPL-RESULT
           else
               add 12 to ZERO giving APPL-RESULT
           end-if
           if  APPL-AOK
               CONTINUE
           else
               move 'CLOSE Failure with ITEMMAST' to MESSAGE-TEXT
               perform Z-DISPLAY-MESSAGE-TEXT
               move ITEMMAST-STATUS to IO-STATUS
               perform Z-DISPLAY-IO-STATUS
               perform Z-ABEND-PROGRAM
           end-if
           exit.
      *---------------------------------------------------------------*
       ITEMMAST-READ.
           read ITEMMAST-FILE
           if  ITEMMAST-STATUS = '00'
               subtract APPL-RESULT from APPL-RESULT
           else
               if  ITEMMAST-STATUS = '10'
                   add 16 to ZERO giving APPL-RESULT
               else
                   add 12 to ZERO giving APPL-RESULT
               end-if
           end-if
           if  APPL-AOK
               CONTINUE
           else
               if  APPL-EOF
                   move 'Y' to ITEMMAST-EOF
               else
                   move 'READ Failure with ITEMMAST' to MESSAGE-TEXT
                   perform Z-DISPLAY-MESSAGE-TEXT
                   move ITEMMAST-STATUS to IO-STATUS
                   perform Z-DISPLAY-IO-STATUS
                   perform Z-ABEND-PROGRAM
               end-if
           end-if
           exit.
      *---------------------------------------------------------------*
       ITEMMAST-OPEN.
           add 8 to ZERO giving APPL-RESULT.
           open input ITEMMAST-FILE
           if  ITEMMAST-STATUS = '00'
               subtract APPL-RESULT from APPL-RESULT
               move 'O' to ITEMMAST-OPEN-FLAG
           else
               add 12 to ZERO giving APPL-RESULT
           end-if
           if  APPL-AOK
               CONTINUE
           else
               move 'OPEN Failure with ITEMMAST' to MESSAGE-TEXT
               perform Z-DISPLAY-MESSAGE-TEXT
               move ITEMMAST-STATUS to IO-STATUS
               perform Z-DISPLAY-IO-STATUS
               perform Z-ABEND-PROGRAM
           end-if
           exit.

      *****************************************************************
      * I/O Routines for the OUTPUT File...                           *
      *****************************************************************
       ITMPRINT-WRITE.
           if  ITMPRINT-OPEN-FLAG = 'C'
               perform ITMPRINT-OPEN
           end-if
           write ITMPRINT-REC after advancing 1
           if  ITMPRINT-STATUS = '00'
               subtract APPL-RESULT from APPL-RESULT
           else
               if  ITMPRINT-STATUS = '10'
                   add 16 to ZERO giving APPL-RESULT
               else
                   add 12 to ZERO giving APPL-RESULT
               end-if
           end-if.
           if  APPL-AOK
               CONTINUE
           else
               move 'WRITE Failure with ITMPRINT' to MESSAGE-TEXT
               perform Z-DISPLAY-MESSAGE-TEXT
               move ITMPRINT-STATUS to IO-STATUS
               perform Z-DISPLAY-IO-STATUS
               perform Z-ABEND-PROGRAM
           end-if
           exit.
       ITMPRINT-WRITE-HDR-1.
           if  ITMPRINT-OPEN-FLAG = 'C'
               perform ITMPRINT-OPEN
           end-if
           write ITMPRINT-REC after advancing page
           if  ITMPRINT-STATUS = '00'
               subtract APPL-RESULT from APPL-RESULT
           else
               if  ITMPRINT-STATUS = '10'
                   add 16 to ZERO giving APPL-RESULT
               else
                   add 12 to ZERO giving APPL-RESULT
               end-if
           end-if.
           if  APPL-AOK
               CONTINUE
           else
               move 'WRITE Failure with ITMPRINT' to MESSAGE-TEXT
               perform Z-DISPLAY-MESSAGE-TEXT
               move ITMPRINT-STATUS to IO-STATUS
               perform Z-DISPLAY-IO-STATUS
               perform Z-ABEND-PROGRAM
           end-if
           exit.
      *---------------------------------------------------------------*
       ITMPRINT-OPEN.
           add 8 to ZERO giving APPL-RESULT.
           open OUTPUT ITMPRINT-FILE
           if  ITMPRINT-STATUS = '00'
               subtract APPL-RESULT from APPL-RESULT
               move 'O' to ITMPRINT-OPEN-FLAG
           else
               add 12 to ZERO giving APPL-RESULT
           end-if
           if  APPL-AOK
               CONTINUE
           else
               move 'OPEN Failure with ITMPRINT' to MESSAGE-TEXT
               perform Z-DISPLAY-MESSAGE-TEXT
               move ITMPRINT-STATUS to IO-STATUS
               perform Z-DISPLAY-IO-STATUS
               perform Z-ABEND-PROGRAM
           end-if
           exit.
      *---------------------------------------------------------------*
       ITMPRINT-CLOSE.
           add 8 to ZERO giving APPL-RESULT.
           close ITMPRINT-FILE
           if  ITMPRINT-STATUS = '00'
               subtract APPL-RESULT from APPL-RESULT
               move 'C' to ITMPRINT-OPEN-FLAG
           else
               add 12 to ZERO giving APPL-RESULT
           end-if
           if  APPL-AOK
               CONTINUE
           else
               move 'CLOSE Failure with ITMPRINT' to MESSAGE-TEXT
               perform Z-DISPLAY-MESSAGE-TEXT
               move ITMPRINT-STATUS to IO-STATUS
               perform Z-DISPLAY-IO-STATUS
               perform Z-ABEND-PROGRAM
           end-if
           exit.

      *****************************************************************
      * The following Z-ROUTINES provide administrative functions     *
      * for this program.                                             *
      *****************************************************************
      * ABEND the program, post a message to the console and issue    *
      * a STOP RUN.                                                   *
      *****************************************************************
       Z-ABEND-PROGRAM.
           if  MESSAGE-TEXT not = SPACES
               perform Z-DISPLAY-MESSAGE-TEXT
           end-if
           move 'PROGRAM-IS-ABENDING...'  to MESSAGE-TEXT
           perform Z-DISPLAY-MESSAGE-TEXT
           add 12 to ZERO giving RETURN-CODE
           STOP RUN.
      *    exit.

      *****************************************************************
      * Display CONSOLE messages...                                   *
      *****************************************************************
       Z-DISPLAY-MESSAGE-TEXT.
           if MESSAGE-TEXT-2 = SPACES
               display MESSAGE-BUFFER(1:79)
           else
               display MESSAGE-BUFFER
           end-if
           move all SPACES to MESSAGE-TEXT
           exit.

      *****************************************************************
      * Display the file status bytes. This routine will display as   *
      * four digits. If the full two byte file status is numeric it   *
      * will display as 00nn. If the 1st byte is a numeric nine (9)   *
      * the second byte will be treated as a binary number and will   *
      * display as 9nnn.                                              *
      *****************************************************************
       Z-DISPLAY-IO-STATUS.
           if  IO-STATUS not NUMERIC
           or  IO-STAT1 = '9'
               move IO-STAT1 to IO-STATUS-04(1:1)
               subtract TWO-BYTES-BINARY from TWO-BYTES-BINARY
               move IO-STAT2 to TWO-BYTES-RIGHT
               add TWO-BYTES-BINARY to ZERO giving IO-STATUS-0403
               move 'File Status is: nnnn' to MESSAGE-TEXT
               move IO-STATUS-04 to MESSAGE-TEXT(17:4)
               perform Z-DISPLAY-MESSAGE-TEXT
           else
               move '0000' to IO-STATUS-04
               move IO-STATUS to IO-STATUS-04(3:2)
               move 'File Status is: nnnn' to MESSAGE-TEXT
               move IO-STATUS-04 to MESSAGE-TEXT(17:4)
               perform Z-DISPLAY-MESSAGE-TEXT
           end-if
           exit.

      *****************************************************************
       Z-POST-COPYRIGHT.
           display SIM-TITLE
           display SIM-COPYRIGHT
           exit.
      *****************************************************************
      *           This program was generated by SimoZAPS              *
      *             A product of SimoTime Technologies                *
      *        Our e-mail address is: helpdesk@simotime.com           *
      *     Also, visit our Web Site at http://www.simotime.com       *
      *                                                               *
      *  Generation Date: 2006-03-30  Generation Time: 13:39:08:07    *
      *****************************************************************
