@echo OFF
rem  * *******************************************************************
rem  *               NUMPRTE1.CMD - a Windows Command File               *
rem  *         This program is provided by SimoTime Technologies         *
rem  *           (C) Copyright 1987-2019 All Rights Reserved             *
rem  *             Web Site URL:   http://www.simotime.com               *
rem  *                   e-mail:   helpdesk@simotime.com                 *
rem  * *******************************************************************
rem  *
rem  * Text   - Read the Item Master File, print a price list.
rem  * Author - SimoTime Technologies
rem  * Date   - January 24, 1996
rem  *
rem  * This set of programs will run on a mainframe under MVS or on a
rem  * Personal Computer with Windows and Micro Focus Net Express.
rem  *
     setlocal
     set CmdName=NUMPRTE1
     call ..\Env1BASE %CmdName%
     set JobStatus=0000
     call SimoNOTE "*******************************************************%CmdName%"
     call SimoNOTE "Starting JobName %CmdName%, User is %USERNAME%"
rem  * *******************************************************************
rem  * Step   1   Set File Mapping, Delete any previously created file...
rem  *
:SetDeleteQSAM
     call SimoNOTE "Identify JobStep DeleteQSAM"
     set ITEMMAST=%BaseLib1%\DATA\APPL\SIMOTIME.DATA.ITEMMAST.DAT
     set ITMPRINT=%BaseLib1%\DATA\WRK1\SIMOTIME.REPORT.ITMPRINT.DAT
     if exist %ITMPRINT% del %ITMPRINT%
rem  *
rem  * *******************************************************************
rem  * Step   2   Edit input, create a new output file...
rem  *
:ExecuteNumericPrint
     call SimoNOTE "Identify JobStep ExecuteNumericPrint"
     run NUMPRTC1
     if not "%ERRORLEVEL%" == "0" set JobStatus=0010
     if not "%JobStatus%" == "0000" goto :EojNOK
rem  *
     if exist %ITMPRINT% (call SimoNOTE "Produced DataSet %ITMPRINT%"
                          goto :EojAOK)
     set JobStatus=0020
     if not "%JobStatus%" == "0000" goto :EojNOK
:EojAOK
     call SimoNOTE "Finished CmdName %CmdName%, Job Status is %JobStatus% "
     goto :End
:EojNOK
     call SimoNOTE "ABENDING CmdName %CmdName%, Job Status is %JobStatus% "
     goto :End
:End
     call SimoNOTE "Conclude SysOut is %SYSOUT%"
     endlocal
     if not "%1" == "nopause" pause
