       IDENTIFICATION DIVISION.
       PROGRAM-ID.    VREC80C3.
       AUTHOR.        SIMOTIME TECHNOLOGIES.
      *****************************************************************
      *           This program was generated by SimoZAPS              *
      *             A product of SimoTime Technologies                *
      *        Our e-mail address is: helpdesk@simotime.com           *
      *     Also, visit our Web Site at http://www.simotime.com       *
      *                                                               *
      *  Generation Date: 2013-05-16  Generation Time: 14:35:28:83    *
      *                                                               *
      *                                   Record    Record     Key    *
      *  Function  Name     Organization  Format    Max-Min  Pos-Len  *
      *  INPUT     VREC80D1 SEQUENTIAL    VARIABLE   00080            *
      *                                              00012            *
      *  OUTPUT    VREC80D2 SEQUENTIAL    VARIABLE   00080            *
      *                                              00012            *
      *                                                               *
      *****************************************************************
       ENVIRONMENT DIVISION.
       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
           SELECT VREC80D1-FILE  ASSIGN TO       VREC80D1
                  ORGANIZATION  IS SEQUENTIAL
                  ACCESS MODE   IS SEQUENTIAL
                  FILE STATUS   IS VREC80D1-STATUS.
           SELECT VREC80D2-FILE  ASSIGN TO       VREC80D2
                  ORGANIZATION  IS SEQUENTIAL
                  ACCESS MODE   IS SEQUENTIAL
                  FILE STATUS   IS VREC80D2-STATUS.
           SELECT SYSUT3-FILE  ASSIGN TO       SYSUT3
                  ORGANIZATION  IS SEQUENTIAL
                  ACCESS MODE   IS SEQUENTIAL
                  FILE STATUS   IS SYSUT3-STATUS.

      *****************************************************************
       DATA DIVISION.
       FILE SECTION.
       FD  VREC80D1-FILE
           DATA RECORD    IS VREC80D1-REC
           RECORDING MODE IS V
           RECORD VARYING FROM 00012 TO 00080
           DEPENDING ON VREC80D1-LRECL
           .
       01  VREC80D1-REC.
           05  VREC80D1-DATA-01 PIC X(00080).

       FD  VREC80D2-FILE
           DATA RECORD    IS VREC80D2-REC
           RECORDING MODE IS V
           RECORD VARYING FROM 00012 TO 00080
           DEPENDING ON VREC80D2-LRECL
           .
       01  VREC80D2-REC.
           05  VREC80D2-DATA-01 PIC X(00080).

       FD  SYSUT3-FILE
           DATA RECORD    IS SYSUT3-REC
           .
       01  SYSUT3-REC.
           05  SYSUT3-DATA-01 PIC X(80).

      *****************************************************************
      * This program was created using the SYSCOMP2.TXT file as the   *
      * template for the data file comparison. The positions to be    *
      * compared are determined by reading a control file at          *
      * execution time.                                               *
      *                                                               *
      * For more information or questions please contact SimoTime     *
      * Technologies. The version control number is 13.05.16          *
      *                                                               *
      *        Our e-mail address is: helpdesk@simotime.com           *
      *     Also, visit our Web Site at http://www.simotime.com       *
      *                                                               *
      *****************************************************************
       WORKING-STORAGE SECTION.
       01  SIM-TITLE.
           05  T1 pic X(11) value '* VREC80C3 '.
           05  T2 pic X(34) value 'Compare Variable-Length Maximum=80'.
           05  T3 pic X(10) value ' v13.05.16'.
           05  T4 pic X(24) value '   helpdesk@simotime.com'.
       01  SIM-COPYRIGHT.
           05  C1 pic X(11) value '* VREC80C3 '.
           05  C2 pic X(32) value 'This Data File Compare Member wa'.
           05  C3 pic X(32) value 's generated by SimoTime Technolo'.
           05  C4 pic X(04) value 'gies'.

       01  SIM-THANKS-01.
           05  C1 pic X(11) value '* VREC80C3 '.
           05  C2 pic X(32) value 'A Data File Compare Program gene'.
           05  C3 pic X(32) value 'rated by using SimoTime Technolo'.
           05  C4 pic X(04) value 'gies'.

       01  SIM-THANKS-02.
           05  C1 pic X(11) value '* VREC80C3 '.
           05  C2 pic X(32) value 'Please send all inquires or sugg'.
           05  C3 pic X(32) value 'estions to the helpdesk@simotime'.
           05  C4 pic X(04) value '.com'.

       01  VREC80D1-STATUS.
           05  VREC80D1-STATUS-L     pic X.
           05  VREC80D1-STATUS-R     pic X.
       01  VREC80D1-EOF              pic X       value 'N'.
       01  VREC80D1-OPEN-FLAG        pic X       value 'C'.

       01  VREC80D2-STATUS.
           05  VREC80D2-STATUS-L     pic X.
           05  VREC80D2-STATUS-R     pic X.
       01  VREC80D2-EOF              pic X       value 'N'.
       01  VREC80D2-OPEN-FLAG        pic X       value 'C'.

       01  SYSUT3-STATUS.
           05  SYSUT3-STATUS-L     pic X.
           05  SYSUT3-STATUS-R     pic X.
       01  SYSUT3-EOF              pic X       value 'N'.
       01  SYSUT3-OPEN-FLAG        pic X       value 'C'.

      *****************************************************************
      * The following buffers are used to create a four-byte status   *
      * code that may be displayed.                                   *
      *****************************************************************
       01  IO-STATUS.
           05  IO-STAT1            pic X.
           05  IO-STAT2            pic X.
       01  IO-STATUS-04.
           05  IO-STATUS-0401      pic 9     value 0.
           05  IO-STATUS-0403      pic 999   value 0.
       01  TWO-BYTES-BINARY        pic 9(4)  BINARY.
       01  TWO-BYTES-ALPHA         redefines TWO-BYTES-BINARY.
           05  TWO-BYTES-LEFT      pic X.
           05  TWO-BYTES-RIGHT     pic X.

      *****************************************************************
      * Message Buffer used by the Z-DISPLAY-MESSAGE-TEXT routine.    *
      *****************************************************************
       01  MESSAGE-BUFFER.
           05  MESSAGE-HEADER      pic X(11)   value '* VREC80C3 '.
           05  MESSAGE-TEXT.
               10  MESSAGE-TEXT-1  pic X(68)   value SPACES.
               10  MESSAGE-TEXT-2  pic X(188)  value SPACES.

      *****************************************************************
       01  APPL-RESULT             pic S9(9)    comp.
           88  APPL-AOK            value 0.
           88  APPL-EOF            value 16.

       01  READ-FLAGS.
           05  READ-1          pic X       value 'Y'.
           05  READ-2          pic X       value 'Y'.
       01  DUMP-FLAGS.
           05  DUMP-ASC        pic X       value 'Y'.
           05  DUMP-EBC        pic X       value 'N'.
           05  DUMP-HEX        pic X       value 'N'.
           05  DUMP-DET-GRP.
               10  DUMP-DET    pic X       value 'Y'.
               10  DUMP-DET-2  pic XX      value 'NE'.
           05  DUMP-SUM        pic X       value 'Y'.

       01  FUNCTION-FLAGS.
           05  FF-01       pic X       value '0'.
           05  FF-02       pic X       value '0'.

       01  COMPACT-STATUS  pic XX      value 'EQ'.
       01  COMPACT-PENDED  pic XX      value 'EQ'.
       01  COMPARE-STATUS  pic XX      value 'EQ'.
       01  FLAG-EQ         pic XX      value 'EQ'.
       01  FLAG-NE         pic XX      value 'NE'.
       01  FLAG-QT         pic XX      value 'QT'.
       01  DELTA-LINE-1    pic X(1024) value all '-'.
       01  DELTA-LINE-2    pic X(1024) value all '-'.
       01  PTR-1           pic 9(5)    value 0.
       01  PTR-2           pic 9(5)    value 0.
       01  IDX-1           pic 9(5)    value 0.
       01  IDX-2           pic 9(5)    value 0.
       01  DELTA-MAXIMUM-X pic X(9)    value '000000010'.
       01  DELTA-MAXIMUM   redefines DELTA-MAXIMUM-X pic 9(9).
       01  DELTA-PROCESS   pic X(4)    value 'EOF '.

       01  IFNECODE-GROUP.
           05  IFNECODE-VALUE pic 9(4) value 0012.

       01  YES-YES         pic XX      value 'YY'.
       01  N-BYTE          pic X       value 'N'.
       01  Y-BYTE          pic X       value 'Y'.

       01  KEY-ACTIVE      pic X       value 'Y'.
       01  KEY-CONTROL-1.
           05  PS-1        pic 9(5)    value 00000.
           05  LN-1        pic 9(5)    value 00000.
       01  KEY-CONTROL-2.
           05  PS-2        pic 9(5)    value 00000.
           05  LN-2        pic 9(5)    value 00000.

       01  VREC80D1-LRECL    pic 9(5)    value 00080.
       01  VREC80D2-LRECL    pic 9(5)    value 00080.
       01  D-LEN           pic 9(5)    value 128.
       01  D-POS           pic 9(5)    value 1.

       01  ASC-OR-EBC      pic 9(3)    comp    value 0.
       01  ASC-OR-EBC-R    redefines ASC-OR-EBC.
           05  ASC-A       pic X.
           05  EBC-A       pic X.

      *    Header row for positional indicator...
       01  DUMP-H10.
           05  FILLER      pic X(5)    value '....:'.
           05  POS-NO      pic 9(5)    value 10.
       01  DUMP-HEADER     pic X(1024) value all '.'.
       01  D-P1            pic 9(5)    value 0.

       01  RECORD-HEADER.
           05  RECORD-ID   pic X(8)    value 'VREC80D1'.
           05  filler      pic X(2)    value '..'.
           05  REC-NUMBER  pic 9(9)    value 0.
           05  filler      pic X       value '('.
           05  RECORD-POS  pic 9(5)    value 0.
           05  filler      pic X       value ':'.
           05  RECORD-LEN  pic 9(5)    value 0.
           05  filler      pic X       value ')'.

       01  SYSLOG-OUTPUT   pic X(4)    value 'OUT1'.
       01  SYSUT3-KEYWORD  pic X(10)   value SPACES.

       01  INFO-STATEMENT.
           05  INFO-SHORT.
               10  INFO-ID pic X(8)    value 'Starting'.
               10  filler  pic X(4)    value '  - '.
               10  INFO-34 pic X(34)
                   value   'Compare Variable-Length Maximum=80'.
           05  filler      pic X(33)
               value '          http://www.SimoTime.com'.

       01  VREC80D1-TOTAL.
           05  VREC80D1-RDR  pic 9(9)  value 0.
           05  filler      pic X(3)  value ' - '.
           05  filler      pic X(25) value 'Record count for VREC80D1'.
       01  VREC80D2-TOTAL.
           05  VREC80D2-RDR  pic 9(9)  value 0.
           05  filler      pic X(3)  value ' - '.
           05  filler      pic X(25) value 'Record count for VREC80D2'.
       01  SYSUT3-TOTAL.
           05  SYSUT3-RDR  pic 9(9)  value 0.
           05  filler      pic X(3)  value ' - '.
           05  filler      pic X(25) value 'Record count for SYSUT3  '.
       01  COMPARE-NE-TOTAL.
           05  COMPARE-NE  pic 9(9)  value 0.
           05  filler      pic X(3)  value ' - '.
           05  COMPARE-TAG.
               10  filler  pic X(25) value 'NOT Equal count for compa'.
               10  filler  pic X(25) value 're of existing records   '.
       01  COMPACT-NE-TOTAL.
           05  COMPACT-NE  pic 9(9)  value 0.
           05  filler      pic X(3)  value ' - '.
           05  COMPACT-TAG.
               10  filler  pic X(25) value 'NOT Equal count for compa'.
               10  filler  pic X(25) value 'ct of existing records   '.
       01  COMPARE-EQ-TOTAL.
           05  COMPARE-EQ  pic 9(9)  value 0.
           05  filler      pic X(3)  value ' - '.
           05  filler      pic X(25) value 'Number of matching record'.
           05  filler      pic X(25) value ' pairs for Compare Task  '.
       01  COMPACT-EQ-TOTAL.
           05  COMPACT-EQ  pic 9(9)  value 0.
           05  filler      pic X(3)  value ' - '.
           05  filler      pic X(25) value 'Number of matching record'.
           05  filler      pic X(25) value ' pairs for Compact Task  '.

       01  FORMAT-TYPE     pic X     value 'B'.
       01  WORK-05-X.
           05  WORK-05-N   pic 9(5).

       01  COMPARE-TABLE.
           05  POS-1       pic 9(5)    value 0 occurs 32 times.
           05  LEN-1       pic 9(5)    value 0 occurs 32 times.
           05  POS-2       pic 9(5)    value 0 occurs 32 times.
           05  LEN-2       pic 9(5)    value 0 occurs 32 times.

       01  CX-LIMIT            pic 9(3)    value 32.
       01  CX-1                pic 9(3)    value 0.
       01  CX-ACTIVE           pic 9(3)    value 0.
       01  SYSUT3-STMTS        pic 9(3)    value 0.

       01  PARSE-TABLE.
           05  PT-OSET         pic 9(3)    value 0 occurs 15 times.
           05  PT-SIZE         pic 9(3)    value 0 occurs 15 times.
       01  PT-LIMIT            pic 9(3)    value 15.

       01  PX-1                pic 9(3)    value 0.
       01  PX-2                pic 9(3)    value 0.
       01  PX-MAX-ITEMS        pic 9(3)    value 15.
       01  PX-ACTIVE           pic 9(3)    value 0.
       01  PX-BUFFER-SIZE      pic 9(3)    value 80.
       01  PX-LAST-SIG-BYTE    pic 9(5)    value 0.
       01  B-COUNT             pic 9(3)    value 0.
       01  DISPLAY-MODE        pic X(10)   value 'CONSOLE   '.
       01  SYSLOG-MODE         pic X(10)   value 'DISABLE   '.
       01  SYSLOG-OUTPUT-FLAG  pic X       value 'N'.
       01  FIVE-BYTES          pic X(5)    value SPACES.
       01  LOOP-FLAG           pic X       value 'A'.

       01  COMPARE-MSG-DATA.
           05  FILLER pic X(30) value 'Error, /COMPARE               '.
           05  FILLER pic X(30) value 'Error, /COMPARE SYSUT1        '.
           05  FILLER pic X(30) value 'Error, /COMPARE SYSUT1 POS    '.
           05  FILLER pic X(30) value 'Error, /COMPARE SYSUT1 POS nnn'.
           05  FILLER pic X(30) value 'Error, /COMPARE SYSUT1 LEN    '.
           05  FILLER pic X(30) value 'Error, /COMPARE SYSUT1 LEN nnn'.
           05  FILLER pic X(30) value 'Error, /COMPARE SYSUT2        '.
           05  FILLER pic X(30) value 'Error, /COMPARE SYSUT2 POS    '.
           05  FILLER pic X(30) value 'Error, /COMPARE SYSUT2 POS nnn'.
           05  FILLER pic X(30) value 'Error, /COMPARE SYSUT2 LEN    '.
           05  FILLER pic X(30) value 'Error, /COMPARE SYSUT2 LEN nnn'.
       01  COMPARE-MSG-DATA-R   redefines COMPARE-MSG-DATA.
           05  COMPARE-MSG      pic X(30)  occurs 11 times.

       01  U-CASE      pic X(26) value 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'.
       01  L-CASE      pic X(26) value 'abcdefghijklmnopqrstuvwxyz'.

       COPY PASSHEX4.
       COPY PASSLOGS.
       COPY PAENVARS.

      *****************************************************************
       PROCEDURE DIVISION.
           perform JOB-STARTING

           perform
               until COMPARE-STATUS = 'QT'
               or    VREC80D1-STATUS not = '00'
               or    VREC80D2-STATUS not = '00'
               if  READ-1 = 'Y'
                   move LOW-VALUES   to    VREC80D1-REC
                   perform VREC80D1-READ
               end-if
               if  READ-2 = 'Y'
                   move LOW-VALUES   to    VREC80D2-REC
                   perform VREC80D2-READ
               end-if
               if  VREC80D1-STATUS = '00'
               and VREC80D2-STATUS = '00'
                   move 'EQ' to COMPARE-STATUS
                   if  KEY-ACTIVE = 'Y'
                       perform COMPARE-KEYS
                   end-if
                   if  COMPARE-STATUS = FLAG-EQ
                       perform COMPARE-RECORDS
                   end-if
                   if  COMPARE-STATUS = FLAG-NE
                       add 1 to COMPARE-NE
                   end-if
               else
                   move 'NE' to COMPARE-STATUS
               end-if
               if  COMPARE-STATUS = 'EQ'
                   add 1 to COMPARE-EQ
               end-if
               if  DELTA-PROCESS = 'QUIT'
               and COMPARE-NE > DELTA-MAXIMUM
                   perform JOB-FINISHED
                   move 'ABENDING, Not Equal count exceeds Limit...'
                     to MESSAGE-TEXT
                   perform Z-ABEND-PROGRAM
               end-if
               if  DELTA-PROCESS = 'EOF '
               and COMPARE-NE > DELTA-MAXIMUM
                   move 'ABENDING, Not Equal count exceeds Limit...'
                     to MESSAGE-TEXT
                   perform Z-DISPLAY-TO-CONSOLE
                   move 'QT' to COMPARE-STATUS
               end-if
           end-perform

           perform JOB-FINISHED

           GOBACK.

      *****************************************************************
       COMPARE-RECORDS.
      *    Compare using SYSUT3 parameters...
           add 1 to ZERO giving CX-1
           perform until CX-1 > CX-LIMIT
                      or CX-1 > CX-ACTIVE
             if  VREC80D1-REC(POS-1(CX-1):LEN-1(CX-1))
                 not = VREC80D2-REC(POS-2(CX-1):LEN-2(CX-1))
                 move FLAG-NE to COMPARE-STATUS
                 move 'Y' to DUMP-DET
             end-if
             if  DUMP-DET = 'Y'
                 add POS-1(CX-1) to ZERO giving D-POS
                 add POS-1(CX-1) to ZERO giving RECORD-POS
                 add LEN-1(CX-1) to ZERO giving D-LEN
                 add LEN-1(CX-1) to ZERO giving PASSHEX4-LENGTH
                 add LEN-1(CX-1) to ZERO giving RECORD-LEN
                 perform DUMP-PRIMARY-RECORD
                 if  DUMP-DET-GRP = 'YNE'
                    add POS-2(CX-1) to ZERO giving D-POS
                    add POS-2(CX-1) to ZERO giving RECORD-POS
                    add LEN-2(CX-1) to ZERO giving D-LEN
                    add LEN-2(CX-1) to ZERO giving PASSHEX4-LENGTH
                    add LEN-2(CX-1) to ZERO giving RECORD-LEN
                    perform DUMP-SECONDARY-RECORD
                    perform DUMP-POSITION-DIFFERENCE
                 end-if
                 move 'N' to DUMP-DET
             end-if
             if  READ-FLAGS not = 'YY'
                 add CX-LIMIT to 1 giving CX-1
             else
                 add 1 to CX-1
             end-if
           end-perform
           exit.

      *****************************************************************
       COMPARE-KEYS.
           move YES-YES to READ-FLAGS
           if  VREC80D1-REC(PS-1:LN-1)
            <  VREC80D2-REC(PS-2:LN-2)
               move N-BYTE to READ-2
               move FLAG-NE to COMPARE-STATUS
               move 'Y' to DUMP-DET
               if  COMPARE-NE < DELTA-MAXIMUM
               and DUMP-DET-GRP = 'YNE'
                   perform DUMP-PRIMARY-MISSING
               end-if
           end-if
           if  VREC80D1-REC(PS-1:LN-1)
            >  VREC80D2-REC(PS-2:LN-2)
               move N-BYTE to READ-1
               move FLAG-NE to COMPARE-STATUS
               move 'Y' to DUMP-DET
               if  COMPARE-NE < DELTA-MAXIMUM
               and DUMP-DET-GRP = 'YNE'
                   perform DUMP-SECONDARY-MISSING
               end-if
           end-if
           move 'N' to DUMP-DET
           exit.

      *****************************************************************
       DUMP-TO-LOG.
      *    HexDump...
      *    Dump DD Name, Record-Number, (position,length)
           move RECORD-HEADER to SIMOLOGS-MESSAGE
           call 'SIMOLOGS' using SIMOLOGS-PASS-AREA
      *    DUMP position indicator
           perform DUMP-POSITION-INDICATOR
           if  DUMP-ASC = 'Y'
               move PASSHEX4-ASCII(1:D-LEN) to SIMOLOGS-MESSAGE
               call 'SIMOLOGS' using SIMOLOGS-PASS-AREA
           end-if
           if  DUMP-HEX = 'Y'
               move PASSHEX4-UPPER(1:D-LEN) to SIMOLOGS-MESSAGE
               call 'SIMOLOGS' using SIMOLOGS-PASS-AREA
               move PASSHEX4-LOWER(1:D-LEN) to SIMOLOGS-MESSAGE
               call 'SIMOLOGS' using SIMOLOGS-PASS-AREA
           end-if
           if  DUMP-EBC = 'Y'
               move PASSHEX4-EBCDIC(1:D-LEN) to SIMOLOGS-MESSAGE
               call 'SIMOLOGS' using SIMOLOGS-PASS-AREA
           end-if
           exit.

      *****************************************************************
      *    Build the position header row...
      *****************************************************************
       DUMP-POSITION-INDICATOR.
           add 9 to D-POS giving POS-NO
           perform varying D-P1 from 1 by 10 until D-P1 > 1020
               move DUMP-H10 to DUMP-HEADER(D-P1:10)
               inspect DUMP-HEADER(D-P1 + 5:5)
                       replacing leading ZEROES by '.'
               add 10 to POS-NO
           end-perform
           move DUMP-HEADER(1:D-LEN) to SIMOLOGS-MESSAGE
           call 'SIMOLOGS' using SIMOLOGS-PASS-AREA
           exit.

      *****************************************************************
       DUMP-PRIMARY-MISSING.
           move 'VREC80D1 Record is missing from VREC80D2 file'
             to SIMOLOGS-MESSAGE
           call 'SIMOLOGS' using SIMOLOGS-PASS-AREA
           move SPACES to PASSHEX4-SOURCE
           add VREC80D1-RDR to ZERO giving REC-NUMBER
           add PS-1 to ZERO giving RECORD-POS
           add LN-1 to ZERO giving RECORD-LEN
           add PS-1 to ZERO giving D-POS
           add LN-1 to ZERO giving D-LEN
           move 'VREC80D1..' to RECORD-ID
           move VREC80D1-REC(PS-1:LN-1) to PASSHEX4-SOURCE
           call 'SIMOHEX4' using PASSHEX4-PASS-AREA
           perform DUMP-TO-LOG
           perform DUMP-POSITION-DIFFERENCE
           exit.

      *****************************************************************
       DUMP-PRIMARY-RECORD.
           move SPACES to PASSHEX4-SOURCE
           if  READ-1 = 'Y'
           and VREC80D1-EOF = 'N'
               move 'VREC80D1..' to RECORD-ID
               add VREC80D1-RDR to ZERO giving REC-NUMBER
               move VREC80D1-REC(D-POS:D-LEN) to PASSHEX4-SOURCE
               call 'SIMOHEX4' using PASSHEX4-PASS-AREA
               perform DUMP-TO-LOG
           else
               move 'VREC80D1..Record is missing from VREC80D1 file'
                 to SIMOLOGS-MESSAGE
               call 'SIMOLOGS' using SIMOLOGS-PASS-AREA
           end-if
           exit.

      *****************************************************************
       DUMP-SECONDARY-MISSING.
           move 'VREC80D2..Record is missing from VREC80D1 file'
             to SIMOLOGS-MESSAGE
           call 'SIMOLOGS' using SIMOLOGS-PASS-AREA
           move SPACES to PASSHEX4-SOURCE
           add VREC80D2-RDR to ZERO giving REC-NUMBER
           add PS-2 to ZERO giving RECORD-POS
           add LN-2 to ZERO giving RECORD-LEN
           add PS-2 to ZERO giving D-POS
           add LN-2 to ZERO giving D-LEN
           move 'VREC80D2..' to RECORD-ID
           move VREC80D2-REC(PS-2:LN-2) to PASSHEX4-SOURCE
           call 'SIMOHEX4' using PASSHEX4-PASS-AREA
           perform DUMP-TO-LOG
           perform DUMP-POSITION-DIFFERENCE
           exit.

      *****************************************************************
       DUMP-SECONDARY-RECORD.
           move SPACES to PASSHEX4-SOURCE
           move 'VREC80D2..' to RECORD-ID
           add VREC80D2-RDR to ZERO giving REC-NUMBER
           move VREC80D2-REC(D-POS:D-LEN) to PASSHEX4-SOURCE
           call 'SIMOHEX4' using PASSHEX4-PASS-AREA
           perform DUMP-TO-LOG
           exit.

      *****************************************************************
       DUMP-POSITION-DIFFERENCE.
           if  READ-FLAGS = 'YY'
               move all '-' to DELTA-LINE-2
               add POS-1(CX-1) to ZERO giving PTR-1
               add POS-2(CX-1) to ZERO giving PTR-2
               add 1 to ZERO giving IDX-2
               perform until IDX-2 > 1024
                          or IDX-2 > D-LEN
                   if  VREC80D1-REC(PTR-1:1)
                    =  VREC80D2-REC(PTR-2:1)
                       move '=' to DELTA-LINE-2(IDX-2:1)
                   else
                       move '#' to DELTA-LINE-2(IDX-2:1)
                   end-if
                   add 1 to PTR-1
                   add 1 to PTR-2
                   add 1 to IDX-2
               end-perform
           else
               move all '#' to DELTA-LINE-2
           end-if
           move DELTA-LINE-2(1:D-LEN) to SIMOLOGS-MESSAGE
           call 'SIMOLOGS' using SIMOLOGS-PASS-AREA
           move '*' to SIMOLOGS-MESSAGE
           call 'SIMOLOGS' using SIMOLOGS-PASS-AREA
           exit.

      *****************************************************************
       JOB-FINISHED.
           if  VREC80D1-STATUS = '00'
           and DELTA-PROCESS   = 'EOF '
               perform until VREC80D1-STATUS not = '00'
                 perform VREC80D1-READ
                 add 1 to COMPARE-NE
               end-perform
           end-if
           if  VREC80D2-STATUS = '00'
           and DELTA-PROCESS   = 'EOF '
               perform until VREC80D2-STATUS not = '00'
                 perform VREC80D2-READ
                 add 1 to COMPARE-NE
               end-perform
           end-if
           perform VREC80D2-CLOSE
           perform VREC80D1-CLOSE

           move 'Conclude' to INFO-ID
           move INFO-SHORT to SIMOLOGS-MESSAGE
           call 'SIMOLOGS' using SIMOLOGS-PASS-AREA
           move 'Finished' to INFO-ID

           move VREC80D1-TOTAL to SIMOLOGS-MESSAGE
           call 'SIMOLOGS' using SIMOLOGS-PASS-AREA

           move VREC80D2-TOTAL to SIMOLOGS-MESSAGE
           call 'SIMOLOGS' using SIMOLOGS-PASS-AREA

           if  VREC80D1-RDR not = VREC80D2-RDR
               move 'WARNING!  - Record counts are not equal'
                 to SIMOLOGS-MESSAGE
               call 'SIMOLOGS' using SIMOLOGS-PASS-AREA
               move 'ABENDING' to INFO-ID
           end-if

           if  COMPARE-NE = 0
               inspect COMPARE-TAG
               replacing first ' of existing records '
                            by ' is ZERO             '
           else
               move 'ABENDING' to INFO-ID
           end-if
           move COMPARE-NE-TOTAL to SIMOLOGS-MESSAGE
           call 'SIMOLOGS' using SIMOLOGS-PASS-AREA
           move COMPARE-EQ-TOTAL to SIMOLOGS-MESSAGE
           call 'SIMOLOGS' using SIMOLOGS-PASS-AREA

           if  COMPACT-NE = 0
               inspect COMPACT-TAG
               replacing first ' of existing records '
                            by ' is ZERO             '
           else
               move 'ABENDING' to INFO-ID
           end-if
           move COMPACT-NE-TOTAL to SIMOLOGS-MESSAGE
           call 'SIMOLOGS' using SIMOLOGS-PASS-AREA

           if  VREC80D1-EOF not = 'Y'
           or  VREC80D2-EOF not = 'Y'
               move 'ABENDING' to INFO-ID
           end-if
           move INFO-STATEMENT to SIMOLOGS-MESSAGE
           call 'SIMOLOGS' using SIMOLOGS-PASS-AREA

           move INFO-SHORT to MESSAGE-TEXT
           perform Z-DISPLAY-MESSAGE-TEXT

           perform Z-THANK-YOU.

           if  COMPARE-NE > 0
           or  VREC80D1-RDR not = VREC80D2-RDR
               add IFNECODE-VALUE to ZERO giving RETURN-CODE
           end-if
           exit.

      *****************************************************************
       JOB-STARTING.
           perform Z-POST-COPYRIGHT
           perform Z-DETERMINE-ENVIRONMENT
           perform JOB-STARTING-GET-CONTROL
           perform VREC80D1-OPEN
           perform VREC80D2-OPEN
           move 'Y' to READ-1
           move 'Y' to READ-2
           if  DELTA-MAXIMUM not numeric
               add 100 to ZERO giving DELTA-MAXIMUM
           end-if
           if  PS-1 > 0
           and PS-2 > 0
           and LN-1 > 0
           and LN-2 > 0
               move 'Y' to KEY-ACTIVE
               move 'Key control is ENABLED...'
                 to MESSAGE-TEXT
           else
               move 'N' to KEY-ACTIVE
               move 'Key control is NOT enabled...'
                 to MESSAGE-TEXT
           end-if
           perform Z-DISPLAY-MESSAGE-TEXT

           move 'DUMP' to PASSHEX4-REQUEST
           add 128 to ZERO giving PASSHEX4-LENGTH
           move SYSLOG-OUTPUT to SIMOLOGS-REQUEST
           move SPACES       to SIMOLOGS-MESSAGE
           move all '*' to SIMOLOGS-MESSAGE(1:80)
           call 'SIMOLOGS' using SIMOLOGS-PASS-AREA
           move INFO-STATEMENT to SIMOLOGS-MESSAGE
           call 'SIMOLOGS' using SIMOLOGS-PASS-AREA
           move all '*' to SIMOLOGS-MESSAGE(1:80)
           call 'SIMOLOGS' using SIMOLOGS-PASS-AREA
           move SIM-TITLE to SIMOLOGS-MESSAGE
           call 'SIMOLOGS' using SIMOLOGS-PASS-AREA
           move SIM-COPYRIGHT to SIMOLOGS-MESSAGE
           call 'SIMOLOGS' using SIMOLOGS-PASS-AREA
           exit.
      *****************************************************************
       JOB-STARTING-GET-CONTROL.
           perform SYSUT3-OPEN
           perform INITIALIZE-TABLE-CX
           perform until SYSUT3-STATUS not = '00'
             perform SYSUT3-READ
             if  SYSUT3-STATUS = '00'
                 move SYSUT3-REC to MESSAGE-TEXT-1
                 perform Z-DISPLAY-MESSAGE-TEXT
                 if  SYSUT3-REC(1:1) = '/'
                     perform INITIALIZE-TABLE-PX
                     inspect SYSUT3-REC converting L-CASE to U-CASE
                     perform PARSE-BUFFER
                     perform PROCESS-CONTROL-RECORD
                  else
                     if  SYSUT3-REC(1:1) not = '*'
                         move 'Preceding Control statement is invalid'
                           to MESSAGE-TEXT
                         perform Z-ABEND-PROGRAM
                     end-if
                  end-if
             else
                 if  SYSUT3-EOF = 'Y'
                     move 'SYSUT3 - End of File...' to MESSAGE-TEXT
                     perform Z-DISPLAY-MESSAGE-TEXT
                     move 'SYSUT3 - Active Compare Statements = &&&'
                       to MESSAGE-TEXT
                     inspect MESSAGE-TEXT replacing first '&&&'
                                                       by CX-ACTIVE
                     perform Z-DISPLAY-MESSAGE-TEXT
                     move 'SYSUT3 - Active Statement Count is = &&&'
                       to MESSAGE-TEXT
                     inspect MESSAGE-TEXT replacing first '&&&'
                                                       by SYSUT3-STMTS
                     perform Z-DISPLAY-MESSAGE-TEXT
                 end-if
             end-if
           end-perform
           perform SYSUT3-CLOSE
           if  SYSLOG-OUTPUT-FLAG = 'Y'
               if  SYSLOG-MODE = 'ENABLE    '
                   evaluate DISPLAY-MODE
                     when 'CONSOLE   ' move 'OPR2' to SYSLOG-OUTPUT
                     when 'SYSOUT    ' move 'OUT2' to SYSLOG-OUTPUT
                     when other        move 'LOG1' to SYSLOG-OUTPUT
                   end-evaluate
               else
                   evaluate DISPLAY-MODE
                     when 'CONSOLE   ' move 'OPR1' to SYSLOG-OUTPUT
                     when 'SYSOUT    ' move 'OUT1' to SYSLOG-OUTPUT
                   end-evaluate
               end-if
           end-if
           exit.

      *****************************************************************
       INITIALIZE-TABLE-CX.
           add 1 to ZERO giving CX-1
           perform until CX-1 > CX-LIMIT
             move 0 to POS-1(CX-1)
             move 0 to LEN-1(CX-1)
             move 0 to POS-2(CX-1)
             move 0 to LEN-2(CX-1)
             add  1 to CX-1
           end-perform
           move ZERO to RETURN-CODE
           subtract CX-1 from CX-1
           exit.

      *****************************************************************
       INITIALIZE-TABLE-PX.
           add 1 to ZERO giving PX-1
           perform until PX-1 > PT-LIMIT
             move 0 to PT-OSET(PX-1)
             move 0 to PT-SIZE(PX-1)
             add  1 to PX-1
           end-perform
           add 1 to ZERO giving PX-1
           add 1 to ZERO giving PX-2
           exit.

      *****************************************************************
       PARSE-BUFFER.
           if  SYSUT3-REC(PX-1:1) not = SPACE
               add PX-1 to ZERO giving PX-LAST-SIG-BYTE
           end-if

           perform until PX-1 > PX-BUFFER-SIZE
             if  SYSUT3-REC(PX-1:1) = SPACE
                 add 1 to B-COUNT
                 if  B-COUNT = 1
                 and PT-SIZE(PX-2) > 0
                     if  PX-2 < PX-MAX-ITEMS
                         add 1 to PX-2
                         add 1 to PX-MAX-ITEMS
                     else
                         move PX-BUFFER-SIZE to PX-2
                     end-if
                 end-if
             else
                 subtract B-COUNT from B-COUNT
                 add 1 to PT-SIZE(PX-2)
                 if  PT-SIZE(PX-2) = 1
                     move PX-1 to PT-OSET(PX-2)
                 end-if
             end-if
             add 1 to PX-1
           end-perform

           exit.

      *****************************************************************
       PROCESS-CONTROL-RECORD.
           add 1 to ZERO giving PX-1
           if  PT-OSET(PX-1) > ZERO
           and PT-SIZE(PX-1) < 11
               move SPACES to SYSUT3-KEYWORD
               move SYSUT3-REC(PT-OSET(PX-1):PT-SIZE(PX-1))
                 to SYSUT3-KEYWORD
               evaluate SYSUT3-KEYWORD
                 when '/COMPARE  '
                      perform PROCESS-CONTROL-RECORD-COMPARE
                 when '/DFORMAT  '
                      perform PROCESS-CONTROL-RECORD-DFORMAT
                 when '/DISPLAY  '
                      add 1 to PX-1
                      move SYSUT3-REC(PT-OSET(PX-1):PT-SIZE(PX-1))
                        to DISPLAY-MODE
                      move 'Y' to SYSLOG-OUTPUT-FLAG
                      add 1 to SYSUT3-STMTS
                 when '/SYSLOG   '
                      add 1 to PX-1
                      move SYSUT3-REC(PT-OSET(PX-1):PT-SIZE(PX-1))
                        to SYSLOG-MODE
                      move 'Y' to SYSLOG-OUTPUT-FLAG
                      add 1 to SYSUT3-STMTS
                 when '/SYSOUT   '
                      add 1 to PX-1
                      if  SYSUT3-REC(PT-OSET(PX-1):8) = 'SYSOUT  '
                      or  SYSUT3-REC(PT-OSET(PX-1):8) = 'CONSOLE '
                      or  SYSUT3-REC(PT-OSET(PX-1):8) = 'NONE    '
                          move SYSUT3-REC(PT-OSET(PX-1):PT-SIZE(PX-1))
                            to DISPLAY-MODE
                            add 1 to SYSUT3-STMTS
                      end-if
                 when other
                      move COMPARE-MSG(PX-1) to MESSAGE-TEXT
                      perform Z-ABEND-PROGRAM
               end-evaluate
           else
               move COMPARE-MSG(PX-1) to MESSAGE-TEXT
               perform Z-ABEND-PROGRAM
           end-if

           exit.

      *****************************************************************
       PROCESS-CONTROL-RECORD-COMPARE.
           add 1 to CX-1
           add 1 to CX-ACTIVE
           add 2 to ZERO giving PX-1
           if  PT-OSET(PX-1) > ZERO
           and PT-SIZE(PX-1) = 6
               if  SYSUT3-REC(PT-OSET(PX-1):PT-SIZE(PX-1))
                   not = 'SYSUT1'
                   move COMPARE-MSG(PX-1) to MESSAGE-TEXT
                   perform Z-ABEND-PROGRAM
               end-if
           else
               move COMPARE-MSG(PX-1) to MESSAGE-TEXT
               perform Z-ABEND-PROGRAM
           end-if
           add 1 to PX-1
           if  PT-OSET(PX-1) > ZERO
           and PT-SIZE(PX-1) = 3
               if  SYSUT3-REC(PT-OSET(PX-1):PT-SIZE(PX-1))
                   not = 'POS'
                   move COMPARE-MSG(PX-1) to MESSAGE-TEXT
                   perform Z-ABEND-PROGRAM
               end-if
           else
               move COMPARE-MSG(PX-1) to MESSAGE-TEXT
               perform Z-ABEND-PROGRAM
           end-if
           add 1 to PX-1
           if  PT-OSET(PX-1) > ZERO
           and PT-SIZE(PX-1) < 6
               move SPACES to WORK-05-X
               move SYSUT3-REC(PT-OSET(PX-1):PT-SIZE(PX-1))
                    to WORK-05-X
               perform RIGHT-ADJUST-05
               if  WORK-05-X is NUMERIC
                   add WORK-05-N to ZERO giving POS-1(CX-1)
               else
                   move COMPARE-MSG(PX-1) to MESSAGE-TEXT
                   perform Z-ABEND-PROGRAM
               end-if
           else
               move COMPARE-MSG(PX-1) to MESSAGE-TEXT
               perform Z-ABEND-PROGRAM
           end-if
           add 1 to PX-1
           if  PT-OSET(PX-1) > ZERO
           and PT-SIZE(PX-1) = 3
               if  SYSUT3-REC(PT-OSET(PX-1):PT-SIZE(PX-1))
                   not = 'LEN'
                   move COMPARE-MSG(PX-1) to MESSAGE-TEXT
                   perform Z-ABEND-PROGRAM
               end-if
           else
               move COMPARE-MSG(PX-1) to MESSAGE-TEXT
               perform Z-ABEND-PROGRAM
           end-if
           add 1 to PX-1
           if  PT-OSET(PX-1) > ZERO
           and PT-SIZE(PX-1) < 6
               move SPACES to WORK-05-X
               move SYSUT3-REC(PT-OSET(PX-1):PT-SIZE(PX-1))
                    to WORK-05-X
               perform RIGHT-ADJUST-05
               if  WORK-05-X is NUMERIC
                   add WORK-05-N to ZERO giving LEN-1(CX-1)
               else
                   move COMPARE-MSG(PX-1) to MESSAGE-TEXT
                   perform Z-ABEND-PROGRAM
               end-if
           else
               move COMPARE-MSG(PX-1) to MESSAGE-TEXT
               perform Z-ABEND-PROGRAM
           end-if

           add 1 to PX-1
           if  PT-OSET(PX-1) > ZERO
           and PT-SIZE(PX-1) = 6
               if  SYSUT3-REC(PT-OSET(PX-1):PT-SIZE(PX-1))
                   not = 'SYSUT2'
                   move COMPARE-MSG(PX-1) to MESSAGE-TEXT
                   perform Z-ABEND-PROGRAM
               end-if
           else
               move COMPARE-MSG(PX-1) to MESSAGE-TEXT
               perform Z-ABEND-PROGRAM
           end-if
           add 1 to PX-1
           if  PT-OSET(PX-1) > ZERO
           and PT-SIZE(PX-1) = 3
               if  SYSUT3-REC(PT-OSET(PX-1):PT-SIZE(PX-1))
                   not = 'POS'
                   move COMPARE-MSG(PX-1) to MESSAGE-TEXT
                   perform Z-ABEND-PROGRAM
               end-if
           else
               move COMPARE-MSG(PX-1) to MESSAGE-TEXT
               perform Z-ABEND-PROGRAM
           end-if
           add 1 to PX-1
           if  PT-OSET(PX-1) > ZERO
           and PT-SIZE(PX-1) < 6
               move SPACES to WORK-05-X
               move SYSUT3-REC(PT-OSET(PX-1):PT-SIZE(PX-1))
                    to WORK-05-X
               perform RIGHT-ADJUST-05
               if  WORK-05-X is NUMERIC
                   add WORK-05-N to ZERO giving POS-2(CX-1)
               else
                   move COMPARE-MSG(PX-1) to MESSAGE-TEXT
                   perform Z-ABEND-PROGRAM
               end-if
           else
               move COMPARE-MSG(PX-1) to MESSAGE-TEXT
               perform Z-ABEND-PROGRAM
           end-if
           add 1 to PX-1
           if  PT-OSET(PX-1) > ZERO
           and PT-SIZE(PX-1) = 3
               if  SYSUT3-REC(PT-OSET(PX-1):PT-SIZE(PX-1))
                   not = 'LEN'
                   move COMPARE-MSG(PX-1) to MESSAGE-TEXT
                   perform Z-ABEND-PROGRAM
               end-if
           else
               move COMPARE-MSG(PX-1) to MESSAGE-TEXT
               perform Z-ABEND-PROGRAM
           end-if
           add 1 to PX-1
           if  PT-OSET(PX-1) > ZERO
           and PT-SIZE(PX-1) < 6
               move SPACES to WORK-05-X
               move SYSUT3-REC(PT-OSET(PX-1):PT-SIZE(PX-1))
                    to WORK-05-X
               perform RIGHT-ADJUST-05
               if  WORK-05-X is NUMERIC
                   add WORK-05-N to ZERO giving LEN-2(CX-1)
               else
                   move COMPARE-MSG(PX-1) to MESSAGE-TEXT
                   perform Z-ABEND-PROGRAM
               end-if
            else
               move COMPARE-MSG(PX-1) to MESSAGE-TEXT
               perform Z-ABEND-PROGRAM
           end-if
           add 1 to SYSUT3-STMTS
           exit.

      *****************************************************************
       PROCESS-CONTROL-RECORD-DFORMAT.
           add 2 to ZERO giving PX-1
           move 'A' to LOOP-FLAG
           perform until LOOP-FLAG = 'Q'
               if  PX-1 < 5
               and PT-OSET(PX-1) > ZERO
               and PT-SIZE(PX-1) < 6
                   move SPACES to FIVE-BYTES
                   move SYSUT3-REC(PT-OSET(PX-1):PT-SIZE(PX-1))
                     to FIVE-BYTES
                   evaluate FIVE-BYTES
                     when 'ASC  ' move 'Y' to DUMP-ASC
                     when 'NOASC' move 'N' to DUMP-ASC
                     when 'EBC  ' move 'Y' to DUMP-EBC
                     when 'NOEBC' move 'N' to DUMP-EBC
                     when 'HEX  ' move 'Y' to DUMP-HEX
                     when 'NOHEX' move 'N' to DUMP-HEX
                   end-evaluate
               else
                   move 'Q' to LOOP-FLAG
               end-if
               add 1 to PX-1
           end-perform
           add 1 to SYSUT3-STMTS
           exit.

      *****************************************************************
       RIGHT-ADJUST-05.
           if  WORK-05-X(5:1) = SPACES
               perform until WORK-05-X(5:1) not = SPACE
                   move WORK-05-X(4:1) to WORK-05-X(5:1)
                   move WORK-05-X(3:1) to WORK-05-X(4:1)
                   move WORK-05-X(2:1) to WORK-05-X(3:1)
                   move WORK-05-X(1:1) to WORK-05-X(2:1)
                   move "0"            to WORK-05-X(1:1)
               end-perform
           end-if
           exit.

      *****************************************************************
      * I/O Routines for the Control File...                          *
      *****************************************************************
       SYSUT3-CLOSE.
           add 8 to ZERO giving APPL-RESULT.
           close SYSUT3-FILE
           if  SYSUT3-STATUS = '00'
               subtract APPL-RESULT from APPL-RESULT
           else
               add 12 to ZERO giving APPL-RESULT
           end-if
           if  APPL-AOK
               CONTINUE
           else
               move 'CLOSE Failure with SYSUT3' to MESSAGE-TEXT
               perform Z-DISPLAY-MESSAGE-TEXT
               move SYSUT3-STATUS to IO-STATUS
               perform Z-DISPLAY-IO-STATUS
               perform Z-ABEND-PROGRAM
           end-if
           exit.
      *---------------------------------------------------------------*
       SYSUT3-READ.
           read SYSUT3-FILE
           if  SYSUT3-STATUS = '00'
               subtract APPL-RESULT from APPL-RESULT
               add 1 to SYSUT3-RDR
           else
               if  SYSUT3-STATUS = '10'
                   add 16 to ZERO giving APPL-RESULT
               else
                   add 12 to ZERO giving APPL-RESULT
               end-if
           end-if
           if  APPL-AOK
               CONTINUE
           else
               if  APPL-EOF
                   move 'Y' to SYSUT3-EOF
               else
                   move 'READ Failure with SYSUT3' to MESSAGE-TEXT
                   perform Z-DISPLAY-MESSAGE-TEXT
                   move SYSUT3-STATUS to IO-STATUS
                   perform Z-DISPLAY-IO-STATUS
                   perform Z-ABEND-PROGRAM
               end-if
           end-if
           exit.
      *---------------------------------------------------------------*
       SYSUT3-OPEN.
           add 8 to ZERO giving APPL-RESULT.
           open input SYSUT3-FILE
           if  SYSUT3-STATUS = '00'
               subtract APPL-RESULT from APPL-RESULT
               move 'O' to SYSUT3-OPEN-FLAG
           else
               add 12 to ZERO giving APPL-RESULT
           end-if
           if  APPL-AOK
               CONTINUE
           else
               move 'OPEN Failure with SYSUT3' to MESSAGE-TEXT
               perform Z-DISPLAY-TO-CONSOLE
               perform Z-DISPLAY-MESSAGE-TEXT
               move SYSUT3-STATUS to IO-STATUS
               perform Z-DISPLAY-IO-STATUS
               perform Z-ABEND-PROGRAM
           end-if
           exit.

      *****************************************************************
      * I/O Routines for the Primary File...                          *
      *****************************************************************
       VREC80D1-CLOSE.
           add 8 to ZERO giving APPL-RESULT.
           close VREC80D1-FILE
           if  VREC80D1-STATUS = '00'
               subtract APPL-RESULT from APPL-RESULT
           else
               add 12 to ZERO giving APPL-RESULT
           end-if
           if  APPL-AOK
               CONTINUE
           else
               move 'CLOSE Failure with VREC80D1' to MESSAGE-TEXT
               perform Z-DISPLAY-MESSAGE-TEXT
               move VREC80D1-STATUS to IO-STATUS
               perform Z-DISPLAY-IO-STATUS
               perform Z-ABEND-PROGRAM
           end-if
           exit.
      *---------------------------------------------------------------*
       VREC80D1-READ.
           read VREC80D1-FILE
           if  VREC80D1-STATUS = '00'
               subtract APPL-RESULT from APPL-RESULT
               add 1 to VREC80D1-RDR
           else
               if  VREC80D1-STATUS = '10'
                   add 16 to ZERO giving APPL-RESULT
               else
                   add 12 to ZERO giving APPL-RESULT
               end-if
           end-if
           if  APPL-AOK
               CONTINUE
           else
               if  APPL-EOF
                   move 'Y' to VREC80D1-EOF
               else
                   move 'READ Failure with VREC80D1' to MESSAGE-TEXT
                   perform Z-DISPLAY-MESSAGE-TEXT
                   move VREC80D1-STATUS to IO-STATUS
                   perform Z-DISPLAY-IO-STATUS
                   perform Z-ABEND-PROGRAM
               end-if
           end-if
           exit.
      *---------------------------------------------------------------*
       VREC80D1-OPEN.
           add 8 to ZERO giving APPL-RESULT.
           open input VREC80D1-FILE
           if  VREC80D1-STATUS = '00'
               subtract APPL-RESULT from APPL-RESULT
               move 'O' to VREC80D1-OPEN-FLAG
           else
               add 12 to ZERO giving APPL-RESULT
           end-if
           if  APPL-AOK
               CONTINUE
           else
               move 'OPEN Failure with VREC80D1' to MESSAGE-TEXT
               perform Z-DISPLAY-TO-CONSOLE
               perform Z-DISPLAY-MESSAGE-TEXT
               move VREC80D1-STATUS to IO-STATUS
               perform Z-DISPLAY-IO-STATUS
               perform Z-ABEND-PROGRAM
           end-if
           exit.

      *****************************************************************
      * I/O Routines for the Secondary File...                        *
      *****************************************************************
       VREC80D2-READ.
           read VREC80D2-FILE
           if  VREC80D2-STATUS = '00'
               subtract APPL-RESULT from APPL-RESULT
               add 1 to VREC80D2-RDR
           else
               if  VREC80D2-STATUS = '10'
                   add 16 to ZERO giving APPL-RESULT
               else
                   add 12 to ZERO giving APPL-RESULT
               end-if
           end-if.
           if  APPL-AOK
               CONTINUE
           else
               if  APPL-EOF
                   move 'Y' to VREC80D2-EOF
               else
                   move 'READ Failure with VREC80D2' to MESSAGE-TEXT
                   perform Z-DISPLAY-MESSAGE-TEXT
                   move VREC80D2-STATUS to IO-STATUS
                   perform Z-DISPLAY-IO-STATUS
                   perform Z-ABEND-PROGRAM
               end-if
           end-if
           exit.
      *---------------------------------------------------------------*
       VREC80D2-OPEN.
           add 8 to ZERO giving APPL-RESULT.
           open input VREC80D2-FILE
           if  VREC80D2-STATUS = '00'
               subtract APPL-RESULT from APPL-RESULT
               move 'O' to VREC80D2-OPEN-FLAG
           else
               add 12 to ZERO giving APPL-RESULT
           end-if
           if  APPL-AOK
               CONTINUE
           else
               move 'OPEN Failure with VREC80D2' to MESSAGE-TEXT
               perform Z-DISPLAY-TO-CONSOLE
               perform Z-DISPLAY-MESSAGE-TEXT
               move VREC80D2-STATUS to IO-STATUS
               perform Z-DISPLAY-IO-STATUS
               perform Z-ABEND-PROGRAM
           end-if
           exit.
      *---------------------------------------------------------------*
       VREC80D2-CLOSE.
           add 8 to ZERO giving APPL-RESULT.
           close VREC80D2-FILE
           if  VREC80D2-STATUS = '00'
               subtract APPL-RESULT from APPL-RESULT
               move 'C' to VREC80D2-OPEN-FLAG
           else
               add 12 to ZERO giving APPL-RESULT
           end-if
           if  APPL-AOK
               CONTINUE
           else
               move 'CLOSE Failure with VREC80D2' to MESSAGE-TEXT
               perform Z-DISPLAY-MESSAGE-TEXT
               move VREC80D2-STATUS to IO-STATUS
               perform Z-DISPLAY-IO-STATUS
               perform Z-ABEND-PROGRAM
           end-if
           exit.

      *****************************************************************
      * The following Z-ROUTINES provide administrative functions     *
      * for this program.                                             *
      *****************************************************************
      * ABEND the program, post a message to the console and issue    *
      * a STOP RUN.                                                   *
      *****************************************************************
       Z-ABEND-PROGRAM.
           if  MESSAGE-TEXT not = SPACES
               perform Z-DISPLAY-MESSAGE-TEXT
           end-if
           move 'PROGRAM-IS-ABENDING...'  to MESSAGE-TEXT
           perform Z-DISPLAY-MESSAGE-TEXT
           add 12 to ZERO giving RETURN-CODE
           STOP RUN.
      *    exit.

      *****************************************************************
       Z-DETERMINE-ENVIRONMENT.
           add 16833 to ASC-OR-EBC
           if  ASC-A = 'A'
               move 'Compiled for an ASCII environment...'
                 to MESSAGE-TEXT
           else
               if  EBC-A = 'A'
                   move 'Compiled for an EBCDIC environment...'
                     to MESSAGE-TEXT
               else
                   move 'Compiled for an UNKNOWN environment...'
                     to MESSAGE-TEXT
               end-if
           end-if
           perform Z-DISPLAY-MESSAGE-TEXT
           exit.

      *****************************************************************
      * Display to SYSOUT Device...                                   *
      *****************************************************************
       Z-DISPLAY-MESSAGE-TEXT.
           if MESSAGE-TEXT-2 = SPACES
               display MESSAGE-BUFFER(1:79)
           else
               display MESSAGE-BUFFER
           end-if
           move all SPACES to MESSAGE-TEXT
           exit.

      *****************************************************************
      * Display CONSOLE messages...                                   *
      *****************************************************************
       Z-DISPLAY-TO-CONSOLE.
           if MESSAGE-TEXT-2 = SPACES
               display MESSAGE-BUFFER(1:79) upon console
           else
               display MESSAGE-BUFFER upon console
           end-if
           exit.

      *****************************************************************
      * Display the file status bytes. This routine will display as   *
      * four digits. If the full two byte file status is numeric it   *
      * will display as 00nn. If the 1st byte is a numeric nine (9)   *
      * the second byte will be treated as a binary number and will   *
      * display as 9nnn.                                              *
      *****************************************************************
       Z-DISPLAY-IO-STATUS.
           if  IO-STATUS not NUMERIC
           or  IO-STAT1 = '9'
               move IO-STAT1 to IO-STATUS-04(1:1)
               subtract TWO-BYTES-BINARY from TWO-BYTES-BINARY
               move IO-STAT2 to TWO-BYTES-RIGHT
               add TWO-BYTES-BINARY to ZERO giving IO-STATUS-0403
               move 'File Status is: nnnn' to MESSAGE-TEXT
               move IO-STATUS-04 to MESSAGE-TEXT(17:4)
               perform Z-DISPLAY-TO-CONSOLE
               perform Z-DISPLAY-MESSAGE-TEXT
           else
               move '0000' to IO-STATUS-04
               move IO-STATUS to IO-STATUS-04(3:2)
               move 'File Status is: nnnn' to MESSAGE-TEXT
               move IO-STATUS-04 to MESSAGE-TEXT(17:4)
               perform Z-DISPLAY-TO-CONSOLE
               perform Z-DISPLAY-MESSAGE-TEXT
           end-if
           exit.

      *****************************************************************
       Z-POST-COPYRIGHT.
           move SIM-TITLE to MESSAGE-BUFFER
           perform Z-DISPLAY-MESSAGE-TEXT
           move SIM-COPYRIGHT to MESSAGE-BUFFER
           perform Z-DISPLAY-MESSAGE-TEXT
           exit.

      *****************************************************************
       Z-THANK-YOU.
           move SIM-THANKS-01 to MESSAGE-BUFFER
           perform Z-DISPLAY-MESSAGE-TEXT
           move SIM-THANKS-02 to MESSAGE-BUFFER
           perform Z-DISPLAY-MESSAGE-TEXT
           exit.
      *****************************************************************
      *           This program was generated by SimoZAPS              *
      *             A product of SimoTime Technologies                *
      *        Our e-mail address is: helpdesk@simotime.com           *
      *     Also, visit our Web Site at http://www.simotime.com       *
      *                                                               *
      *  Generation Date: 2013-05-16  Generation Time: 14:35:28:89    *
      *****************************************************************
